/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.system.paas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.xforceplus.elephant.basecommon.annotation.LogApi;
import com.xforceplus.elephant.basecommon.enums.log.ReceiverEnum;
import com.xforceplus.elephant.basecommon.enums.log.SenderEnum;
import com.xforceplus.elephant.basecommon.enums.log.SystemTypeEnum;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.log.MainHeader;
import com.xforceplus.elephant.basecommon.log.MyThreadLocal;
import com.xforceplus.elephant.basecommon.system.paas.PaasTokenUtils;
import com.xforceplus.elephant.basecommon.system.paas.SystemPaasSettings;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrgUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SystemPaasSettings systemPaasSettings;
    @Autowired
    private PaasTokenUtils paasTokenUtils;
    private Cache<Map<String, String>, JSONArray> hitOrgCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    private Cache<Map<String, String>, JSONArray> missOrgCache = CacheBuilder.newBuilder().expireAfterWrite(3L, TimeUnit.MINUTES).build();

    @LogApi(methodCode="getOrgs", methodDescription="\u7ec4\u7ec7\u5217\u8868\u67e5\u8be2", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PHOENIX)
    public JSONArray getOrgs(Long tenantId, Map<String, String> params) {
        if (ValidatorUtil.isEmpty(params)) {
            return new JSONArray();
        }
        params.put("status", "1");
        try {
            MainHeader mainHeader = MyThreadLocal.setObject(tenantId, String.valueOf(tenantId));
            JSONArray array = (JSONArray)this.missOrgCache.getIfPresent(params);
            if (array != null) {
                this.logger.info("\u7ec4\u7ec7\u5217\u8868\u67e5\u8be2\u547d\u4e2dmiss\u7f13\u5b58");
                return array;
            }
            array = (JSONArray)this.hitOrgCache.getIfPresent(params);
            if (array != null) {
                this.logger.info("\u7ec4\u7ec7\u5217\u8868\u67e5\u8be2\u547d\u4e2dhit\u7f13\u5b58");
                return array;
            }
            String url = this.systemPaasSettings.getSelectSysOrgUrl().replace("{tenantId}", String.valueOf(tenantId));
            String token = this.paasTokenUtils.getLoginToken();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            headers.put("x-app-token", token);
            this.logger.debug("\u53d1\u8d77\u7ec4\u7ec7\u67e5\u8be2\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, url, JSON.toJSONString(params)});
            mainHeader.setMethodUrl(url);
            String responseStr = HttpUtils.doGet(url, headers, params);
            this.logger.debug("\u53d1\u8d77\u7ec4\u7ec7\u67e5\u8be2\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            JSONObject resultObject = JSONObject.parseObject((String)responseStr);
            if (ValidatorUtil.isEmpty((Map)resultObject)) {
                this.logger.warn("\u53d1\u8d77\u6839\u7ec4\u7ec7\u67e5\u8be2\u5f02\u5e38");
                throw new ElephantException("\u53d1\u8d77\u6839\u7ec4\u7ec7\u67e5\u8be2\u5f02\u5e38");
            }
            String respCode = resultObject.getString("code");
            String respMsg = resultObject.getString("message");
            if (!"1".equals(respCode)) {
                throw new ElephantException(respMsg);
            }
            JSONObject result = resultObject.getJSONObject("result");
            if (ValidatorUtil.isNotEmpty((Map)result)) {
                array = result.getJSONArray("content");
            }
            if (ValidatorUtil.isEmpty(array)) {
                this.missOrgCache.put(params, (Object)array);
            } else {
                this.hitOrgCache.put(params, (Object)array);
            }
            return array;
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u8d77\u6839\u7ec4\u7ec7\u67e5\u8be2\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u53d1\u8d77\u6839\u7ec4\u7ec7\u67e5\u8be2\u5f02\u5e38", e);
        }
    }
}

