/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.help;

import com.lowagie.text.DocumentException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.xhtmlrenderer.pdf.ITextFontResolver;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class JavaToPdfImgHtmlFreeMarker {
    private static final String DEST = "target/HelloWorld_CN_HTML_FREEMARKER_FS_IMG.png";
    private static final String HTML = "template_freemarker_fs.html";
    private static final String FONT = "simhei.ttf";
    private static final String LOGO_PATH = "file:///logo.png";
    private static final String IMG_EXT = "png";
    private static Configuration freemarkerCfg = null;

    public static void main(String[] args) throws IOException, org.dom4j.DocumentException, DocumentException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("name", "\u9c81\u5bb6\u5b81");
        String content = JavaToPdfImgHtmlFreeMarker.freeMarkerRender(data, HTML);
        ByteArrayOutputStream pdfStream = JavaToPdfImgHtmlFreeMarker.createPdf(content);
        ByteArrayOutputStream imgSteam = JavaToPdfImgHtmlFreeMarker.pdfToImg(pdfStream.toByteArray(), 2.0f, 1, IMG_EXT);
        FileOutputStream fileStream = new FileOutputStream(new File(DEST));
        fileStream.write(imgSteam.toByteArray());
        fileStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String freeMarkerRender(Map<String, Object> data, String htmlTmp) {
        StringWriter out = new StringWriter();
        try {
            Template template = freemarkerCfg.getTemplate(htmlTmp);
            template.setEncoding("UTF-8");
            template.process(data, (Writer)out);
            ((Writer)out).flush();
            String string = ((Object)out).toString();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                ((Writer)out).close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream createPdf(String content) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ITextRenderer render = new ITextRenderer();
        ITextFontResolver fontResolver = render.getFontResolver();
        try {
            fontResolver.addFont(FONT, "Identity-H", false);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        render.setDocumentFromString(content);
        render.getSharedContext().setBaseURL(LOGO_PATH);
        render.layout();
        try {
            render.createPDF((OutputStream)outStream);
            ByteArrayOutputStream e = outStream;
            return e;
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        finally {
            try {
                outStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static ByteArrayOutputStream pdfToImg(byte[] bytes, float scaling, int pageNum, String formatName) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        return out;
    }

    static {
        freemarkerCfg = new Configuration();
        try {
            freemarkerCfg.setDirectoryForTemplateLoading(new File(LOGO_PATH));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

