/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.help.pdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang.ObjectUtils;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.impl.code128.Code128Bean;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;

public class BarCodeUtils {
    public static byte[] generateBarCode128(String message, Double height, Double width, boolean withQuietZone, boolean hideText) {
        Code128Bean bean = new Code128Bean();
        int dpi = 512;
        bean.doQuietZone(withQuietZone);
        bean.setBarHeight(((Double)ObjectUtils.defaultIfNull((Object)height, (Object)9.0)).doubleValue());
        if (width != null) {
            bean.setModuleWidth(width.doubleValue());
        }
        if (hideText) {
            bean.setMsgPosition(HumanReadablePlacement.HRP_NONE);
        }
        String format = "image/png";
        ByteArrayOutputStream ous = new ByteArrayOutputStream();
        BitmapCanvasProvider canvas = new BitmapCanvasProvider((OutputStream)ous, format, dpi, 12, false, 0);
        bean.generateBarcode((CanvasProvider)canvas, message);
        try {
            canvas.finish();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ous.toByteArray();
    }
}

