/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.help.pdf;

import com.xforceplus.elephant.basecommon.help.pdf.FileTools;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

@Component
public class FreemarkerUtil {
    private Configuration freemarkerConfig;
    @Autowired
    protected ResourceLoader resourceLoader;
    @Autowired
    private FileTools fileTools;

    @PostConstruct
    public void initConfig() throws Exception {
        this.freemarkerConfig = new Configuration(Configuration.VERSION_2_3_23);
        this.freemarkerConfig.setClassForTemplateLoading(this.getClass(), "/template/");
    }

    public Template getTemplate(String name) {
        Template temp = null;
        try {
            temp = this.freemarkerConfig.getTemplate(name, "UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return temp;
    }

    public String generateFileByTemplate(String name, Object data) {
        String outFileName = this.fileTools.getTempFileName(UUID.randomUUID().toString(), ".html");
        this.fileTools.createFile(outFileName);
        this.printFile(name, data, outFileName);
        return outFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printFile(String name, Object root, String outFile) {
        OutputStreamWriter out = null;
        try {
            out = new FileWriter(new File(outFile));
            Template temp = this.getTemplate(name);
            temp.process(root, (Writer)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printString(String name, Object root) {
        StringWriter out = new StringWriter();
        try {
            Template temp = this.getTemplate(name);
            temp.process(root, (Writer)out);
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return out.toString();
    }
}

