/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.help.pdf;

import com.lowagie.text.DocumentException;
import com.xforceplus.elephant.basecommon.help.pdf.FileTools;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;
import org.xhtmlrenderer.pdf.ITextFontResolver;
import org.xhtmlrenderer.pdf.ITextRenderer;

@Component
public class PdfUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private FileTools fileTools;
    @Autowired
    protected ResourceLoader resourceLoader;

    public String createTempPDF(File file) {
        String outputFile = this.fileTools.getTempFileName(UUID.randomUUID().toString(), ".pdf");
        this.fileTools.createFile(outputFile);
        try {
            FileOutputStream os = new FileOutputStream(outputFile);
            this.createPDF(file, (OutputStream)os);
        }
        catch (FileNotFoundException e) {
            this.logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01", (Throwable)e);
        }
        catch (DocumentException e) {
            this.logger.error("\u751f\u6210pdf\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error("\u751f\u6210PDF\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
        }
        return outputFile;
    }

    public String createTempPDF(String fileContent, String fileName) {
        String outputFile = this.fileTools.getTempFileName(fileName, ".pdf");
        this.fileTools.createFile(outputFile);
        try {
            FileOutputStream os = new FileOutputStream(outputFile);
            this.createPDF(fileContent, (OutputStream)os);
        }
        catch (FileNotFoundException e) {
            this.logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01", (Throwable)e);
        }
        catch (DocumentException e) {
            this.logger.error("\u751f\u6210pdf\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error("\u751f\u6210PDF\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
        }
        return outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPDF(File file, OutputStream os) throws IOException, DocumentException {
        String outputFile = this.fileTools.getTempFileName("tmpFontFile", ".ttc");
        this.fileTools.createFile(outputFile);
        File out = new File(outputFile);
        ITextRenderer render = this.buildiTextRenderer(out);
        render.setDocument(file.toURI().toURL().toString());
        render.layout();
        try {
            render.createPDF(os);
        }
        catch (DocumentException e) {
            this.logger.error("\u521b\u5efapdf\u6587\u6863\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            try {
                os.close();
                FileUtils.deleteDirectory((File)new File(out.getParent()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPDF(String fileContent, OutputStream os) throws IOException, DocumentException {
        String outputFile = this.fileTools.getTempFileName("tmpFontFile", ".ttc");
        this.fileTools.createFile(outputFile);
        File out = new File(outputFile);
        ITextRenderer render = this.buildiTextRenderer(out);
        render.setDocumentFromString(fileContent);
        render.layout();
        try {
            render.createPDF(os);
        }
        catch (DocumentException e) {
            this.logger.error("\u521b\u5efapdf\u6587\u6863\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            try {
                os.close();
                FileUtils.deleteDirectory((File)new File(out.getParent()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private ITextRenderer buildiTextRenderer(File file) throws DocumentException, IOException {
        ITextRenderer render = new ITextRenderer();
        ITextFontResolver fontResolver = render.getFontResolver();
        InputStream is = this.getClass().getResourceAsStream("/pdftemplate/simsun.ttc");
        FileUtils.copyInputStreamToFile((InputStream)is, (File)file);
        fontResolver.addFont(file.getAbsolutePath(), "Identity-H", false);
        return render;
    }

    public String createTempPDF(File file, String fileExtension) {
        String outputFile = this.fileTools.getTempFileName(UUID.randomUUID().toString(), ".pdf");
        this.fileTools.createFile(outputFile);
        try {
            FileOutputStream os = new FileOutputStream(outputFile);
            this.createPDF(file, os, fileExtension);
        }
        catch (FileNotFoundException e) {
            this.logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01", (Throwable)e);
        }
        catch (DocumentException e) {
            this.logger.error("\u751f\u6210pdf\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error("\u751f\u6210PDF\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
        }
        return outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPDF(File file, OutputStream os, String fileExtension) throws IOException, DocumentException {
        String outputFile = this.fileTools.getTempFileName("tmpFontFile", fileExtension);
        this.fileTools.createFile(outputFile);
        File out = new File(outputFile);
        ITextRenderer render = this.buildiTextRenderer(out, "/template/simhei.ttf");
        render.setDocument(file.toURI().toURL().toString());
        render.layout();
        try {
            render.createPDF(os);
        }
        catch (DocumentException e) {
            this.logger.error("\u521b\u5efapdf\u6587\u6863\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            try {
                os.close();
                FileUtils.deleteDirectory((File)new File(out.getParent()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private ITextRenderer buildiTextRenderer(File file, String path) throws DocumentException, IOException {
        ITextRenderer render = new ITextRenderer();
        ITextFontResolver fontResolver = render.getFontResolver();
        InputStream is = this.getClass().getResourceAsStream(path);
        FileUtils.copyInputStreamToFile((InputStream)is, (File)file);
        fontResolver.addFont(file.getAbsolutePath(), "Identity-H", false);
        return render;
    }

    public static void yPic(List<BufferedImage> piclist, String outPath) {
        if (piclist == null || piclist.size() <= 0) {
            System.out.println("\u56fe\u7247\u6570\u7ec4\u4e3a\u7a7a!");
            return;
        }
        int rows = piclist.size();
        int cols = 1;
        try {
            BufferedImage[] buffImages = new BufferedImage[piclist.size()];
            for (int i = 0; i < piclist.size(); ++i) {
                buffImages[i] = piclist.get(i);
            }
            int type = buffImages[0].getType();
            int chunkWidth = buffImages[0].getWidth();
            int chunkHeight = buffImages[0].getHeight();
            BufferedImage finalImg = new BufferedImage(chunkWidth * cols, chunkHeight * rows, type);
            int num = 0;
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    finalImg.createGraphics().drawImage((Image)buffImages[num], chunkWidth * j, chunkHeight * i, null);
                    ++num;
                }
            }
            System.out.println("Image concatenated.....");
            File outFile = new File(outPath);
            ImageIO.write((RenderedImage)finalImg, "jpg", outFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream createPdf(String content) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ITextRenderer render = new ITextRenderer();
        ITextFontResolver fontResolver = render.getFontResolver();
        try {
            fontResolver.addFont("/template/simhei.ttf", "Identity-H", false);
        }
        catch (DocumentException var16) {
            var16.printStackTrace();
        }
        catch (IOException var17) {
            var17.printStackTrace();
        }
        render.setDocumentFromString(content);
        render.layout();
        try {
            ByteArrayOutputStream var4;
            render.createPDF((OutputStream)outStream);
            ByteArrayOutputStream byteArrayOutputStream = var4 = outStream;
            return byteArrayOutputStream;
        }
        catch (DocumentException var18) {
            var18.printStackTrace();
        }
        finally {
            try {
                outStream.close();
            }
            catch (IOException var15) {
                var15.printStackTrace();
            }
        }
        return null;
    }
}

