/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.help.excel;

import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.metadata.BaseRowModel;
import com.alibaba.excel.metadata.Sheet;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.xforceplus.elephant.basecommon.help.excel.ExcelListener;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import reactor.util.function.Tuple3;

public class EasyExcelHelp {
    private static Logger logger = LoggerFactory.getLogger(EasyExcelHelp.class);

    public static ByteArrayOutputStream export(List<? extends BaseRowModel> data, String sheetName, Class<? extends BaseRowModel> clazz) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (!CollectionUtils.isEmpty(data) || null != clazz) {
            ExcelWriter excelWriter = new ExcelWriter((OutputStream)outputStream, ExcelTypeEnum.XLSX);
            int sheetNo = 1;
            try {
                Sheet sheet = new Sheet(sheetNo, 0, clazz);
                sheet.setSheetName(sheetName);
                sheet.setAutoWidth(Boolean.TRUE);
                excelWriter.write(data, sheet);
                excelWriter.finish();
            }
            catch (Exception ex) {
                logger.error("\u5bfc\u51fa\u5f02\u5e38", (Throwable)ex);
            }
        }
        return outputStream;
    }

    public static ByteArrayOutputStream exportSheets(List<Tuple3<List<? extends BaseRowModel>, String, Class<? extends BaseRowModel>>> datas) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (ValidatorUtil.isEmpty(datas)) {
            return outputStream;
        }
        ExcelWriter excelWriter = new ExcelWriter((OutputStream)outputStream, ExcelTypeEnum.XLSX);
        for (int sheetNo = 0; sheetNo < datas.size(); ++sheetNo) {
            Tuple3<List<? extends BaseRowModel>, String, Class<? extends BaseRowModel>> data = datas.get(sheetNo);
            try {
                Sheet sheet = new Sheet(sheetNo + 1, 0, (Class)data.getT3());
                sheet.setSheetName((String)data.getT2());
                sheet.setAutoWidth(Boolean.TRUE);
                excelWriter.write((List)data.getT1(), sheet);
                continue;
            }
            catch (Exception ex) {
                logger.error("\u5bfc\u51fa\u5f02\u5e38", (Throwable)ex);
            }
        }
        excelWriter.finish();
        return outputStream;
    }

    public static <T extends BaseRowModel> List<T> readExcel(InputStream inputStream, Class<? extends BaseRowModel> clazz) {
        if (null == inputStream) {
            throw new NullPointerException("the inputStream is null!");
        }
        ExcelListener listener = new ExcelListener();
        ExcelReader reader = new ExcelReader(inputStream, ExcelTypeEnum.valueOf((InputStream)inputStream), null, listener);
        reader.read(new Sheet(1, 1, clazz));
        return listener.getRows();
    }
}

