/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.system.paas;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.LogApi;
import com.xforceplus.elephant.basecommon.enums.common.YesOrNoEnum;
import com.xforceplus.elephant.basecommon.enums.log.ReceiverEnum;
import com.xforceplus.elephant.basecommon.enums.log.SenderEnum;
import com.xforceplus.elephant.basecommon.enums.log.SystemTypeEnum;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.log.MainHeader;
import com.xforceplus.elephant.basecommon.log.MyThreadLocal;
import com.xforceplus.elephant.basecommon.system.paas.PaasTokenUtils;
import com.xforceplus.elephant.basecommon.system.paas.SystemPaasSettings;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OfdImageUtils {
    private Logger logger = LoggerFactory.getLogger(PaasTokenUtils.class);
    @Autowired
    private SystemPaasSettings systemPaasSettings;
    @Autowired
    private PaasTokenUtils paasTokenUtils;

    @LogApi(methodCode="ofdTranForm", methodDescription="ofd\u8f6c\u56fe\u7247", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.MELETE)
    public String ofdTranForm(Long tenantId, String filePath) {
        String imageUrl = "";
        MainHeader mainHeader = MyThreadLocal.setObject(tenantId, filePath);
        String url = this.systemPaasSettings.getOfdTranForm().replace("{tenantId}", String.valueOf(tenantId));
        String token = this.paasTokenUtils.getLoginToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("x-app-token", token);
        JSONObject bodyJson = new JSONObject();
        bodyJson.put("title", (Object)"tenantId");
        bodyJson.put("group", (Object)String.valueOf(tenantId));
        bodyJson.put("file", (Object)filePath);
        bodyJson.put("fileSuffix", (Object)".ofd");
        mainHeader.setMethodUrl(url);
        String responseStr = HttpUtils.doJsonPost(url, headers, bodyJson.toJSONString());
        JSONObject jsonObject = JSONObject.parseObject((String)responseStr);
        int code = jsonObject.getIntValue("code");
        if (YesOrNoEnum.YES.getCode().equals(code)) {
            return jsonObject.getString("result");
        }
        mainHeader.fail(jsonObject.getString("message"), responseStr);
        return imageUrl;
    }
}

