/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.help;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.Coordinate;
import net.coobird.thumbnailator.geometry.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtils {
    private static Logger log = LoggerFactory.getLogger(ImageUtils.class);

    public static void main(String[] args) {
        ImageUtils.scale("e:/abc.jpg", "e:/abc_scale.jpg", 2.0);
        ImageUtils.scale("e:/abc.jpg", "e:/abc_scale2.jpg", 500, 300);
        ImageUtils.cut("e:/abc.jpg", "e:/abc_cut.jpg", 0, 0, 400, 400);
        ImageUtils.pressImage("e:/abc2.jpg", "e:/abc.jpg", "e:/abc_pressImage.jpg", 0, 0, 0.5f);
    }

    public static final boolean scale(String srcFile, String distFile, double scale) {
        try {
            Thumbnails.of((String[])new String[]{srcFile}).scale(scale).toFile(distFile);
            return true;
        }
        catch (IOException e) {
            log.error("\u56fe\u7247\u5904\u7406\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public static final boolean scale(String srcFile, String distFile, int width, int height) {
        try {
            Thumbnails.of((String[])new String[]{srcFile}).scale((double)width, (double)height).toFile(distFile);
            return true;
        }
        catch (IOException e) {
            log.error("\u56fe\u7247\u5904\u7406\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public static final boolean cut(String srcFile, String distFile, int x, int y, int width, int height) {
        try {
            Thumbnails.of((String[])new String[]{srcFile}).sourceRegion(x, y, width, height).toFile(distFile);
            return true;
        }
        catch (IOException e) {
            log.error("\u56fe\u7247\u5904\u7406\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public static final boolean pressImage(String pressImg, String srcFile, String distFile, int x, int y, float alpha) {
        try {
            Thumbnails.of((String[])new String[]{srcFile}).watermark((Position)new Coordinate(x, y), ImageIO.read(new File(pressImg)), alpha).toFile(distFile);
            return true;
        }
        catch (IOException e) {
            log.error("\u56fe\u7247\u5904\u7406\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public static String getImageFormatName(File file) throws IOException {
        String formatName = null;
        ImageInputStream iis = ImageIO.createImageInputStream(file);
        Iterator<ImageReader> imageReader = ImageIO.getImageReaders(iis);
        if (imageReader.hasNext()) {
            ImageReader reader = imageReader.next();
            formatName = reader.getFormatName();
        }
        return formatName;
    }

    public static boolean compressImage(File srcFile, File distFile) throws IOException {
        try {
            Thumbnails.of((File[])new File[]{srcFile}).scale(1.0).outputQuality(0.1f).toFile(distFile);
            return true;
        }
        catch (IOException e) {
            log.error("\u56fe\u7247\u5904\u7406\u5931\u8d25", (Throwable)e);
            return false;
        }
    }
}

