/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.help;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.channels.FileChannel;

public class FileUtils {
    public File createDir(String dirName) {
        File dir = new File(dirName);
        dir.mkdir();
        return dir;
    }

    public static File createFile(String folderPath, String fileName) {
        File file = new File(folderPath);
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    public boolean isFileExist(String fileName) {
        File file = new File(fileName);
        return file.exists();
    }

    public static void copyFile(File from, File to) {
        if (null == from || !from.exists()) {
            return;
        }
        if (null == to) {
            return;
        }
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            is = new FileInputStream(from);
            if (!to.exists()) {
                to.createNewFile();
            }
            os = new FileOutputStream(to);
            FileUtils.copyFileFast(is, os);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(FileUtils.class.getClass().getName(), e);
            }
            catch (Throwable throwable) {
                FileUtils.closeIO(is, os);
                throw throwable;
            }
        }
        FileUtils.closeIO(is, os);
    }

    public static void copyFileFast(FileInputStream is, FileOutputStream os) throws IOException {
        FileChannel in = is.getChannel();
        FileChannel out = os.getChannel();
        in.transferTo(0L, in.size(), out);
    }

    public static void closeIO(Closeable ... closeables) {
        if (null == closeables || closeables.length <= 0) {
            return;
        }
        for (Closeable cb : closeables) {
            try {
                if (null == cb) continue;
                cb.close();
            }
            catch (IOException e) {
                throw new RuntimeException(FileUtils.class.getClass().getName(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeString2File(String res, String filePath, String fileName) {
        boolean flag = true;
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            int len;
            File distFile = FileUtils.createFile(filePath, fileName);
            if (!distFile.getParentFile().exists()) {
                distFile.getParentFile().mkdirs();
            }
            bufferedReader = new BufferedReader(new StringReader(res));
            bufferedWriter = new BufferedWriter(new FileWriter(distFile));
            char[] buf = new char[1024];
            while ((len = bufferedReader.read(buf)) != -1) {
                bufferedWriter.write(buf, 0, len);
            }
            bufferedWriter.flush();
            bufferedReader.close();
            bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = flag = false;
            return bl;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File writeInputStream2File(InputStream input, String filePath, String fileName) {
        int FILESIZE = 4096;
        File file = null;
        OutputStream output = null;
        try {
            int length;
            this.createDir(filePath);
            file = FileUtils.createFile(filePath, fileName);
            output = new FileOutputStream(file);
            byte[] buffer = new byte[FILESIZE];
            while ((length = input.read(buffer)) > 0) {
                output.write(buffer, 0, length);
            }
            output.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                output.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public static void writeByte2File(byte[] input, String filePath, String fileName) {
        File folder = new File(filePath);
        folder.mkdirs();
        File file = new File(filePath, fileName);
        ByteArrayInputStream is = new ByteArrayInputStream(input);
        FileOutputStream os = null;
        if (!file.exists()) {
            try {
                file.createNewFile();
                os = new FileOutputStream(file);
                byte[] buffer = new byte[1024];
                int len = 0;
                while (-1 != (len = is.read(buffer))) {
                    ((OutputStream)os).write(buffer, 0, len);
                }
                os.flush();
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(FileUtils.class.getClass().getName(), e);
                }
                catch (Throwable throwable) {
                    FileUtils.closeIO(is, os);
                    throw throwable;
                }
            }
            FileUtils.closeIO(is, os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStringFromFile(String filePath, String encoding) {
        InputStreamReader reader = null;
        StringWriter writer = new StringWriter();
        try {
            reader = encoding == null || "".equals(encoding.trim()) ? new InputStreamReader((InputStream)new FileInputStream(filePath), encoding) : new InputStreamReader(new FileInputStream(filePath));
            char[] buffer = new char[1024];
            int n = 0;
            while (-1 != (n = reader.read(buffer))) {
                writer.write(buffer, 0, n);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (writer != null) {
            return writer.toString();
        }
        return null;
    }

    public static byte[] readBytesFromFile(String filePath) {
        byte[] buffer = null;
        try {
            int n;
            File file = new File(filePath);
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    public static String getFileSuffix(String fileName) {
        int start = fileName.lastIndexOf(".");
        int end = fileName.length();
        if (fileName.contains("?")) {
            end = fileName.indexOf("?");
        }
        String suffix = fileName.substring(start, end);
        return suffix;
    }
}

