/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.help.excel;

import com.alibaba.excel.EasyExcel;
import com.xforceplus.elephant.basecommon.help.excel.ExcelListener;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.util.function.Tuple3;

public class EasyExcelHelp {
    private static Logger logger = LoggerFactory.getLogger(EasyExcelHelp.class);

    public static <T> ByteArrayOutputStream export(List<T> data, String sheetName, Class<T> clazz) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (ValidatorUtil.isEmpty(data) || clazz == null) {
            return outputStream;
        }
        EasyExcel.write((OutputStream)outputStream, clazz).sheet(sheetName).doWrite(data);
        return outputStream;
    }

    public static <T> ByteArrayOutputStream exportSheets(List<Tuple3<List<T>, String, Class<T>>> datas) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (ValidatorUtil.isEmpty(datas)) {
            return outputStream;
        }
        datas.forEach(data -> EasyExcel.write((OutputStream)outputStream, (Class)((Class)data.getT3())).sheet((String)data.getT2()).doWrite((List)data.getT1()));
        return outputStream;
    }

    public static <T> void export(OutputStream outputStream, List<T> data, String sheetName, Class<T> clazz) {
        if (ValidatorUtil.isEmpty(data) || clazz == null) {
            return;
        }
        EasyExcel.write((OutputStream)outputStream, clazz).sheet(sheetName).doFill(data);
    }

    public static void exportSheets(OutputStream outputStream, List<Tuple3<List, String, Class>> datas) {
        if (ValidatorUtil.isEmpty(datas)) {
            return;
        }
        datas.forEach(data -> EasyExcel.write((OutputStream)outputStream, (Class)((Class)data.getT3())).sheet((String)data.getT2()).doWrite((List)data.getT1()));
    }

    public static <T> List<T> readExcel(InputStream inputStream, Class<T> clazz) {
        if (null == inputStream) {
            throw new NullPointerException("the inputStream is null!");
        }
        ExcelListener listener = new ExcelListener();
        EasyExcel.read((InputStream)inputStream, clazz, listener).sheet().doRead();
        return listener.getRows();
    }

    public static <T> ByteArrayOutputStream append(InputStream is, List<T> data, String sheetName, Class<T> clazz) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (ValidatorUtil.isEmpty(data) || clazz == null) {
            return outputStream;
        }
        EasyExcel.write((OutputStream)outputStream).withTemplate(is).sheet(sheetName).doWrite(data);
        return outputStream;
    }

    public static <T> ByteArrayOutputStream appendSheets(InputStream is, List<Tuple3<List<T>, String, Class<T>>> datas) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (ValidatorUtil.isEmpty(datas)) {
            return outputStream;
        }
        datas.forEach(data -> EasyExcel.write((OutputStream)outputStream, (Class)((Class)data.getT3())).withTemplate(is).sheet((String)data.getT2()).doWrite((List)data.getT1()));
        return outputStream;
    }

    public static <T> void append(OutputStream outputStream, InputStream is, List<T> data, String sheetName, Class<T> clazz) {
        if (ValidatorUtil.isEmpty(data) || clazz == null) {
            return;
        }
        EasyExcel.write((OutputStream)outputStream).withTemplate(is).sheet(sheetName).doWrite(data);
    }

    public static <T> void appendSheets(OutputStream outputStream, InputStream is, List<Tuple3<List<T>, String, Class<T>>> datas) {
        if (ValidatorUtil.isEmpty(datas)) {
            return;
        }
        datas.forEach(data -> EasyExcel.write((OutputStream)outputStream, (Class)((Class)data.getT3())).withTemplate(is).sheet((String)data.getT2()).doWrite((List)data.getT1()));
    }
}

