/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.openapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.xforceplus.elephant.basecommon.annotation.LogApi;
import com.xforceplus.elephant.basecommon.enums.log.ReceiverEnum;
import com.xforceplus.elephant.basecommon.enums.log.SenderEnum;
import com.xforceplus.elephant.basecommon.enums.log.SystemTypeEnum;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.log.MainHeader;
import com.xforceplus.elephant.basecommon.log.MyThreadLocal;
import com.xforceplus.elephant.basecommon.openapi.entity.TicketBackResultEntity;
import com.xforceplus.elephant.basecommon.openapi.settings.OpenapiWilmarSettings;
import com.xforceplus.elephant.basecommon.system.paas.OrgUtils;
import com.xforceplus.elephant.basecommon.system.paas.PaasTokenUtils;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
public class OpenapiWilmarUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private OpenapiWilmarSettings openapiWilmarSettings;
    @Autowired
    private PaasTokenUtils paasTokenUtils;
    @Autowired
    private OrgUtils orgUtils;

    @LogApi(methodCode="origBackEpmHandleResult", methodDescription="\u539f\u4ef6\u9000\u56de\u5904\u7406\u7ed3\u679c\u540c\u6b65EPM", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.JANUS)
    public String origBackEpmHandleResult(Long tenantId, String billCode, String status) {
        try {
            MainHeader mainHeader = MyThreadLocal.setObject(tenantId, billCode, billCode);
            mainHeader.setMethodUrl(this.openapiWilmarSettings.getSyncEpmOrigBackResultUrl());
            if (StringHelp.safeIsEmpty(this.openapiWilmarSettings.getSyncEpmOrigBackResultUrl())) {
                return "\u539f\u4ef6\u9000\u56de\u5904\u7406\u7ed3\u679c\u540c\u6b65EPM\u5931\u8d25\uff0c\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a";
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("businessId", billCode);
            params.put("status", status);
            this.logger.debug("\u539f\u4ef6\u9000\u56de\u5904\u7406\u7ed3\u679c\u540c\u6b65EPM\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, this.openapiWilmarSettings.getSyncEpmOrigBackResultUrl(), JSON.toJSONString(params)});
            String responseStr = HttpUtils.doJsonPost(this.openapiWilmarSettings.getSyncEpmOrigBackResultUrl(), headers, JSON.toJSONString(params));
            this.logger.debug("\u539f\u4ef6\u9000\u56de\u5904\u7406\u7ed3\u679c\u540c\u6b65EPM\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u539f\u4ef6\u9000\u56de\u5904\u7406\u7ed3\u679c\u540c\u6b65EPM\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u539f\u4ef6\u9000\u56de\u5904\u7406\u7ed3\u679c\u540c\u6b65EPM\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="origBackMkHandleResult", methodDescription="\u539f\u4ef6\u9000\u56de\u5904\u7406\u7ed3\u679c\u540c\u6b65MK", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.JANUS)
    public String origBackMkHandleResult(Long tenantId, String billCode, String status) {
        try {
            MainHeader mainHeader = MyThreadLocal.setObject(tenantId, billCode, billCode);
            mainHeader.setMethodUrl(this.openapiWilmarSettings.getSyncMkOrigBackResultUrl());
            if (StringHelp.safeIsEmpty(this.openapiWilmarSettings.getSyncMkOrigBackResultUrl())) {
                return "\u539f\u4ef6\u9000\u56de\u5904\u7406\u7ed3\u679c\u540c\u6b65MK\u5931\u8d25\uff0c\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a";
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("formCode", billCode);
            params.put("status", status);
            this.logger.debug("\u539f\u4ef6\u9000\u56de\u5904\u7406\u7ed3\u679c\u540c\u6b65MK\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, this.openapiWilmarSettings.getSyncMkOrigBackResultUrl(), JSON.toJSONString(params)});
            String responseStr = HttpUtils.doJsonPost(this.openapiWilmarSettings.getSyncMkOrigBackResultUrl(), headers, JSON.toJSONString(params));
            this.logger.debug("\u539f\u4ef6\u9000\u56de\u5904\u7406\u7ed3\u679c\u540c\u6b65MK\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u539f\u4ef6\u9000\u56de\u5904\u7406\u7ed3\u679c\u540c\u6b65MK\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u539f\u4ef6\u9000\u56de\u5904\u7406\u7ed3\u679c\u540c\u6b65MK\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="syncImageUploadInfo", methodDescription="\u540c\u6b65\u5f71\u50cf\u4e0a\u4f20\u4fe1\u606f\u7ed9sharepoint", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.JANUS)
    public String syncImageUploadInfo(Long tenantId, String billCode, String invoiceNo, String invoiceCode, Map<String, Object> imageMap) {
        try {
            MainHeader mainHeader = MyThreadLocal.setObject(tenantId, billCode, billCode, invoiceNo, invoiceCode);
            mainHeader.setMethodUrl(this.openapiWilmarSettings.getSyncSharepointUploadUrl());
            if (StringHelp.safeIsEmpty(this.openapiWilmarSettings.getSyncSharepointUploadUrl())) {
                return "\u540c\u6b65\u5f71\u50cf\u4e0a\u4f20\u4fe1\u606f\u7ed9sharepoint\u5931\u8d25\uff0c\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a";
            }
            if (imageMap.containsKey("imageBase64") && ValidatorUtil.isEmpty(imageMap.get("imageBase64"))) {
                this.logger.warn("\u5f71\u50cf\u5730\u5740\u4e3a\u7a7a");
                mainHeader.fail("\u5f71\u50cf\u5730\u5740\u4e3a\u7a7a", null);
                return null;
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            String param = JSON.toJSONString(imageMap);
            this.logger.debug("\u540c\u6b65\u5f71\u50cf\u4e0a\u4f20\u4fe1\u606f\u7ed9sharepoint\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)tenantId, (Object)this.openapiWilmarSettings.getSyncSharepointUploadUrl());
            String responseStr = HttpUtils.doJsonPost(this.openapiWilmarSettings.getSyncSharepointUploadUrl(), headers, param);
            this.logger.debug("\u540c\u6b65\u5f71\u50cf\u4e0a\u4f20\u4fe1\u606f\u7ed9sharepoint\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u540c\u6b65\u5f71\u50cf\u4e0a\u4f20\u4fe1\u606f\u7ed9sharepoint\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u540c\u6b65\u5f71\u50cf\u4e0a\u4f20\u4fe1\u606f\u7ed9sharepoint\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="syncImageDeleteInfo", methodDescription="\u540c\u6b65\u5f71\u50cf\u5220\u9664\u4fe1\u606f\u7ed9sharepoint", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.JANUS)
    public String syncImageDeleteInfo(Long tenantId, String billCode, List<String> imageUrls) {
        try {
            MainHeader mainHeader = MyThreadLocal.setObject(tenantId, billCode, billCode);
            mainHeader.setMethodUrl(this.openapiWilmarSettings.getSyncSharepointDeleteUrl());
            if (StringHelp.safeIsEmpty(this.openapiWilmarSettings.getSyncSharepointDeleteUrl())) {
                return "\u540c\u6b65\u5f71\u50cf\u5220\u9664\u4fe1\u606f\u7ed9sharepoint\u5931\u8d25\uff0c\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a";
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("barCode", billCode);
            params.put("paths", imageUrls);
            String param = JSON.toJSONString(params);
            this.logger.debug("\u540c\u6b65\u5f71\u50cf\u5220\u9664\u4fe1\u606f\u7ed9sharepoint\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, this.openapiWilmarSettings.getSyncSharepointDeleteUrl(), param});
            String responseStr = HttpUtils.doJsonPost(this.openapiWilmarSettings.getSyncSharepointDeleteUrl(), headers, param);
            this.logger.debug("\u540c\u6b65\u5f71\u50cf\u5220\u9664\u4fe1\u606f\u7ed9sharepoint\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u540c\u6b65\u5f71\u50cf\u5220\u9664\u4fe1\u606f\u7ed9sharepoint\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u540c\u6b65\u5f71\u50cf\u5220\u9664\u4fe1\u606f\u7ed9sharepoint\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="syncImageModifyInfo", methodDescription="\u540c\u6b65\u53d1\u7968\u4fee\u6539\u4fe1\u606f\u7ed9sharepoint", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.JANUS)
    public String syncImageModifyInfo(Long tenantId, String billCode, String invoiceNo, String invoiceCode, Map<String, Object> imageMap) {
        try {
            MainHeader mainHeader = MyThreadLocal.setObject(tenantId, billCode, billCode, invoiceNo, invoiceCode);
            mainHeader.setMethodUrl(this.openapiWilmarSettings.getSyncSharepointModifyUrl());
            if (StringHelp.safeIsEmpty(this.openapiWilmarSettings.getSyncSharepointModifyUrl())) {
                return "\u540c\u6b65\u53d1\u7968\u4fee\u6539\u4fe1\u606f\u7ed9sharepoint\u5931\u8d25\uff0c\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a";
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            String param = JSON.toJSONString(imageMap);
            this.logger.debug("\u540c\u6b65\u53d1\u7968\u4fee\u6539\u4fe1\u606f\u7ed9sharepoint\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, this.openapiWilmarSettings.getSyncSharepointModifyUrl(), param});
            String responseStr = HttpUtils.doJsonPost(this.openapiWilmarSettings.getSyncSharepointModifyUrl(), headers, param);
            this.logger.debug("\u540c\u6b65\u53d1\u7968\u4fee\u6539\u4fe1\u606f\u7ed9sharepoint\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u540c\u6b65\u53d1\u7968\u4fee\u6539\u4fe1\u606f\u7ed9sharepoint\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u540c\u6b65\u53d1\u7968\u4fee\u6539\u4fe1\u606f\u7ed9sharepoint\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="syncOriginalBackInfo", methodDescription="\u540c\u6b65\u53d6\u56de\u539f\u4ef6\u7ed9sharepoint", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.JANUS)
    public String syncOriginalBackInfo(Long tenantId, String billCode, List<String> imageUrl) {
        try {
            MainHeader mainHeader = MyThreadLocal.setObject(tenantId, billCode, billCode);
            mainHeader.setMethodUrl(this.openapiWilmarSettings.getSyncSharepointDeleteUrl());
            if (StringHelp.safeIsEmpty(this.openapiWilmarSettings.getSyncSharepointDeleteUrl())) {
                return "\u540c\u6b65\u53d6\u56de\u539f\u4ef6\u7ed9sharepoint\u5931\u8d25\uff0c\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a";
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("barCode", billCode);
            params.put("paths", imageUrl);
            String paramStr = JSON.toJSONString(params);
            this.logger.debug("\u540c\u6b65\u53d6\u56de\u539f\u4ef6\u7ed9sharepoint\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, this.openapiWilmarSettings.getSyncSharepointDeleteUrl(), paramStr});
            String responseStr = HttpUtils.doJsonPost(this.openapiWilmarSettings.getSyncSharepointDeleteUrl(), headers, paramStr);
            this.logger.debug("\u540c\u6b65\u53d6\u56de\u539f\u4ef6\u7ed9sharepoint\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u540c\u6b65\u53d6\u56de\u539f\u4ef6\u7ed9sharepoint\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u540c\u6b65\u53d6\u56de\u539f\u4ef6\u7ed9sharepoint\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="syncImageUrlExpense", methodDescription="\u5355\u636e\u5e26\u6709MK\u6807\u8bc6\u540c\u6b65\u5f71\u50cf\u5730\u5740MK", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.JANUS)
    public String syncImageUrlExpense(Long tenantId, String billCode, List<String> imageUrls) {
        try {
            MainHeader mainHeader = MyThreadLocal.setObject(tenantId, billCode, billCode);
            mainHeader.setMethodUrl(this.openapiWilmarSettings.getSyncMkImageUrl());
            if (StringHelp.safeIsEmpty(this.openapiWilmarSettings.getSyncMkImageUrl())) {
                return "\u5355\u636e\u5e26\u6709MK\u6807\u8bc6\u540c\u6b65\u5f71\u50cf\u5730\u5740MK\u5931\u8d25\uff0c\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a";
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("formCode", billCode);
            params.put("invoiceImageUrls", imageUrls);
            this.logger.debug("\u5355\u636e\u5e26\u6709MK\u6807\u8bc6\u540c\u6b65\u5f71\u50cf\u5730\u5740MK\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, this.openapiWilmarSettings.getSyncMkImageUrl(), JSON.toJSONString(params)});
            String responseStr = HttpUtils.doJsonPost(this.openapiWilmarSettings.getSyncMkImageUrl(), headers, JSON.toJSONString(params));
            this.logger.debug("\u5355\u636e\u5e26\u6709MK\u6807\u8bc6\u540c\u6b65\u5f71\u50cf\u5730\u5740MK\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636e\u5e26\u6709MK\u6807\u8bc6\u540c\u6b65\u5f71\u50cf\u5730\u5740MK\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u5355\u636e\u5e26\u6709MK\u6807\u8bc6\u540c\u6b65\u5f71\u50cf\u5730\u5740MK\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="syncBillTicketInfoForSAP", methodDescription="\u540c\u6b65\u5c01\u9762\u53d1\u7968\u6e05\u5355\u7ed9SAP", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.JANUS)
    public String syncBillTicketInfoForSAP(Long tenantId, String billCode, Map<String, Object> ticketMap) {
        try {
            MainHeader mainHeader = MyThreadLocal.setObject(tenantId, billCode, billCode);
            mainHeader.setMethodUrl(this.openapiWilmarSettings.getSyncSapArchiveUrl());
            if (StringHelp.safeIsEmpty(this.openapiWilmarSettings.getSyncSapArchiveUrl())) {
                return "\u540c\u6b65\u5c01\u9762\u53d1\u7968\u6e05\u5355\u7ed9SAP\u5931\u8d25\uff0c\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a";
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            String param = JSON.toJSONString(ticketMap);
            this.logger.debug("\u540c\u6b65\u5c01\u9762\u53d1\u7968\u6e05\u5355\u7ed9SAP\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, this.openapiWilmarSettings.getSyncSapArchiveUrl(), param});
            String responseStr = HttpUtils.doJsonPost(this.openapiWilmarSettings.getSyncSapArchiveUrl(), headers, param);
            this.logger.debug("\u540c\u6b65\u5c01\u9762\u53d1\u7968\u6e05\u5355\u7ed9SAP\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u540c\u6b65\u5c01\u9762\u53d1\u7968\u6e05\u5355\u7ed9SAP\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u540c\u6b65\u5c01\u9762\u53d1\u7968\u6e05\u5355\u7ed9SAP\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="syncBillImageInfoForEPM", methodDescription="\u540c\u6b65\u5ba1\u6838\u4fe1\u606f\u7ed9EPM", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.JANUS)
    public String syncBillImageInfoForEPM(Long tenantId, String billCode, Map<String, Object> ticketMap) {
        try {
            MainHeader mainHeader = MyThreadLocal.setObject(tenantId, billCode, billCode);
            mainHeader.setMethodUrl(this.openapiWilmarSettings.getSyncEpmInfoUrl());
            if (StringHelp.safeIsEmpty(this.openapiWilmarSettings.getSyncEpmInfoUrl())) {
                return "\u540c\u6b65\u5ba1\u6838\u4fe1\u606f\u7ed9EPM\u5931\u8d25\uff0c\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a";
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            String param = JSON.toJSONString(ticketMap);
            this.logger.debug("\u540c\u6b65\u5ba1\u6838\u4fe1\u606f\u7ed9EPM\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, this.openapiWilmarSettings.getSyncEpmInfoUrl(), param});
            String responseStr = HttpUtils.doJsonPost(this.openapiWilmarSettings.getSyncEpmInfoUrl(), headers, param);
            this.logger.debug("\u540c\u6b65\u5ba1\u6838\u4fe1\u606f\u7ed9EPM\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u540c\u6b65\u5ba1\u6838\u4fe1\u606f\u7ed9EPM\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u540c\u6b65\u5ba1\u6838\u4fe1\u606f\u7ed9EPM\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="syncTicketImageForPurchaser", methodDescription="\u540c\u6b65\u5355\u8bc1\u5f71\u50cf\u6570\u636e\u7ed9purchaser", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.JANUS)
    public String syncTicketImageForPurchaser(Long tenantId, String billCode, List<Map<String, Object>> billTicketList) {
        try {
            MainHeader mainHeader = MyThreadLocal.setObject(tenantId, billCode, billCode);
            mainHeader.setMethodUrl(this.openapiWilmarSettings.getSyncPurchaserImageUrl());
            if (StringHelp.safeIsEmpty(this.openapiWilmarSettings.getSyncPurchaserImageUrl())) {
                return "\u540c\u6b65\u5355\u8bc1\u5f71\u50cf\u6570\u636e\u7ed9purchaser\u5931\u8d25\uff0c\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a";
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            String param = JSON.toJSONString(billTicketList);
            this.logger.debug("\u540c\u6b65\u5355\u8bc1\u5f71\u50cf\u6570\u636e\u7ed9purchaser\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, this.openapiWilmarSettings.getSyncPurchaserImageUrl(), param});
            String responseStr = HttpUtils.doJsonPost(this.openapiWilmarSettings.getSyncPurchaserImageUrl(), headers, param);
            this.logger.debug("\u540c\u6b65\u5355\u8bc1\u5f71\u50cf\u6570\u636e\u7ed9purchaser\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u540c\u6b65\u5355\u8bc1\u5f71\u50cf\u6570\u636e\u7ed9purchaser\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u540c\u6b65\u5355\u8bc1\u5f71\u50cf\u6570\u636e\u7ed9purchaser\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="ticketBackResult", methodDescription="\u9000\u56de\u5904\u7406\u72b6\u6001\u7ed9\u8fdb\u9879", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PURCHASER)
    public String backResultForPurchaser(List<TicketBackResultEntity> backResultEntityList) {
        try {
            Long tenantId = backResultEntityList.get(0).getTenantId();
            String number = backResultEntityList.stream().map(TicketBackResultEntity::getInvoiceNo).collect(Collectors.joining());
            String invoiceCodes = backResultEntityList.stream().map(TicketBackResultEntity::getInvoiceCode).collect(Collectors.joining());
            MainHeader mainHeader = MyThreadLocal.setObject(tenantId, number, number, invoiceCodes);
            mainHeader.setMethodUrl(this.openapiWilmarSettings.getSyncBackResult());
            if (StringHelp.safeIsEmpty(this.openapiWilmarSettings.getSyncBackResult())) {
                return "\u9000\u56de\u5904\u7406\u72b6\u6001\u7ed9\u8fdb\u9879\u5931\u8d25\uff0c\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a";
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            String param = JSONObject.toJSONString(backResultEntityList);
            this.logger.debug("\u9000\u56de\u5904\u7406\u72b6\u6001\u7ed9\u8fdb\u9879\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, this.openapiWilmarSettings.getSyncPurchaserImageUrl(), param});
            String responseStr = HttpUtils.doJsonPost(this.openapiWilmarSettings.getSyncBackResult(), headers, param);
            this.logger.debug("\u9000\u56de\u5904\u7406\u72b6\u6001\u7ed9\u8fdb\u9879\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u9000\u56de\u5904\u7406\u72b6\u6001\u7ed9\u8fdb\u9879\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u9000\u56de\u5904\u7406\u72b6\u6001\u7ed9\u8fdb\u9879\u5f02\u5e38", e);
        }
    }

    @Cacheable(cacheNames={"supplierDataCache"}, key="#root.args[0]+ ':' + #root.args[1]", unless="#result == null || #result.size() == 0")
    @LogApi(methodCode="getSupplierData", methodDescription="\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PURCHASER)
    public JSONObject getSupplierData(String identifierNo, String taxNo) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (ValidatorUtil.isNotEmpty(identifierNo)) {
            params.put("identifierNo", identifierNo);
        }
        if (ValidatorUtil.isNotEmpty(taxNo)) {
            params.put("taxNo", taxNo);
        }
        if (params.size() == 0) {
            MyThreadLocal.setObject(null, "\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f");
            return null;
        }
        MainHeader mainHeader = MyThreadLocal.setObject(null, (String)params.values().iterator().next());
        try {
            String url = this.openapiWilmarSettings.getSupplierDataUrl();
            String token = this.paasTokenUtils.getLoginToken();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            headers.put("x-app-token", token);
            this.logger.debug("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)url, (Object)JSON.toJSONString(params));
            mainHeader.setMethodUrl(url);
            String responseStr = HttpUtils.doPost(url, headers, null, JSON.toJSONString(params));
            this.logger.debug("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)responseStr);
            JSONObject resultObject = JSONObject.parseObject((String)responseStr);
            if (ValidatorUtil.isEmpty((Map)resultObject)) {
                this.logger.warn("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5f02\u5e38");
                throw new ElephantException("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5f02\u5e38");
            }
            String respCode = resultObject.getString("code");
            String respMsg = resultObject.getString("message");
            if (!"1".equals(respCode)) {
                throw new ElephantException(respMsg);
            }
            return resultObject.getJSONObject("result");
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5f02\u5e38", e);
        }
    }

    @Cacheable(cacheNames={"supplierDataCache"}, key="#root.args[0]", unless="#result == null || #result eq ''")
    @LogApi(methodCode="getSellerCompanyNo", methodDescription="\u83b7\u53d6\u4f9b\u5e94\u5546\u7f16\u53f7", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PURCHASER)
    public String getSellerCompanyNo(String sellerTaxNo) {
        try {
            if (ValidatorUtil.isEmpty(sellerTaxNo)) {
                return "";
            }
            JSONObject result = this.getSupplierData(null, sellerTaxNo);
            if (ValidatorUtil.isEmpty((Map)result)) {
                return "";
            }
            if (ValidatorUtil.isNotEmpty(result.getString("identifierNo"))) {
                return result.getString("identifierNo");
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return "";
    }

    @LogApi(methodCode="checkPurchaserBillType", methodDescription="\u6821\u9a8c\u8d2d\u65b9\u662f\u5426\u6709\u8be5\u5355\u636e\u7c7b\u578b", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PHOENIX)
    public boolean checkPurchaserBillType(Long tenantId, String purchaserTaxNo, String billEntityCode) {
        MyThreadLocal.setObject(tenantId, purchaserTaxNo);
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            if (ValidatorUtil.isNotEmpty(purchaserTaxNo)) {
                params.put("taxNum", purchaserTaxNo);
            }
            params.put("withExtendParams", "extensions");
            JSONArray orgs = this.orgUtils.getOrgs(tenantId, params);
            for (int i = 0; i < orgs.size(); ++i) {
                JSONObject org = orgs.getJSONObject(i);
                JSONArray exts = org.getJSONArray("extensions");
                if (ValidatorUtil.isEmpty(exts)) continue;
                for (int j = 0; j < exts.size(); ++j) {
                    JSONObject ext = exts.getJSONObject(j);
                    if (!"billEntityCode".equals(ext.getString("extensionKey")) || !ext.getString("extensionValue").contains(billEntityCode)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u6821\u9a8c\u8d2d\u65b9\u662f\u5426\u6709\u8be5\u5355\u636e\u7c7b\u578b\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
        return false;
    }

    @Cacheable(cacheNames={"getSalesbillInfoRedis"}, key="#root.args[0]+':'+#root.args[1]", unless="#result == null || #result.size() == 0")
    @LogApi(methodCode="getSalesbillInfo", methodDescription="\u83b7\u53d6\u8fdb\u9879\u4e1a\u52a1\u5355\u4fe1\u606f", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PURCHASER)
    public String getSalesbillInfo(Long tenantId, String salesbillNo) {
        try {
            MainHeader mainHeader = MyThreadLocal.setObject(tenantId, salesbillNo, salesbillNo);
            mainHeader.setMethodUrl(this.openapiWilmarSettings.getSalesbillInfoUrl());
            if (StringHelp.safeIsEmpty(this.openapiWilmarSettings.getSalesbillInfoUrl())) {
                return "\u83b7\u53d6\u8fdb\u9879\u4e1a\u52a1\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a";
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("salesbillNo", salesbillNo);
            String param = JSON.toJSONString(params);
            this.logger.debug("\u83b7\u53d6\u8fdb\u9879\u4e1a\u52a1\u5355\u4fe1\u606f\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, this.openapiWilmarSettings.getSalesbillInfoUrl(), param});
            String responseStr = HttpUtils.doJsonPost(this.openapiWilmarSettings.getSalesbillInfoUrl(), headers, param);
            this.logger.debug("\u83b7\u53d6\u8fdb\u9879\u4e1a\u52a1\u5355\u4fe1\u606f\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8fdb\u9879\u4e1a\u52a1\u5355\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u83b7\u53d6\u8fdb\u9879\u4e1a\u52a1\u5355\u4fe1\u606f\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="checkSalesbill", methodDescription="\u6821\u9a8c\u7ed3\u7b97\u5355\u662f\u5426\u5b58\u5728", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PURCHASER)
    public JSONObject checkSalesbill(Long tenantId, String salesbillNo) {
        JSONObject result = new JSONObject();
        try {
            MyThreadLocal.setObject(tenantId, salesbillNo);
            String responseStr = this.getSalesbillInfo(tenantId, salesbillNo);
            if (ValidatorUtil.isEmpty(responseStr)) {
                return result;
            }
            JSONObject resultJson = JSONObject.parseObject((String)responseStr);
            if (ValidatorUtil.isEmpty((Map)resultJson)) {
                return result;
            }
            String code = resultJson.getString("code");
            if ("1".equals(code) && ValidatorUtil.isNotEmpty((Map)resultJson.getJSONObject("result"))) {
                JSONObject resultobj = resultJson.getJSONObject("result");
                result.put("salesbillNo", (Object)resultobj.getString("salesbillNo"));
                JSONArray detail = resultobj.getJSONArray("detail");
                if (ValidatorUtil.isNotEmpty(detail)) {
                    String currencyKey = "";
                    ArrayList orderNoList = Lists.newArrayList();
                    for (int i = 0; i < detail.size(); ++i) {
                        JSONObject contentObj = detail.getJSONObject(i);
                        if (ValidatorUtil.isEmpty(currencyKey) && ValidatorUtil.isNotEmpty(contentObj.getString("currencyKey"))) {
                            currencyKey = contentObj.getString("currencyKey").toUpperCase();
                        }
                        if (!ValidatorUtil.isNotEmpty(contentObj.getString("purchasingDocumentNumber"))) continue;
                        orderNoList.add(contentObj.getString("purchasingDocumentNumber"));
                    }
                    result.put("currencyKey", (Object)currencyKey);
                    result.put("orderNo", (Object)orderNoList.stream().collect(Collectors.joining(",")));
                }
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u6821\u9a8c\u5f53\u524d\u5355\u636e\u6216\u5355\u8bc1\u662f\u5426\u5c5e\u4e8e\u672c\u7ec4\u7ec7\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u6821\u9a8c\u5f53\u524d\u5355\u636e\u6216\u5355\u8bc1\u662f\u5426\u5c5e\u4e8e\u672c\u7ec4\u7ec7\u5f02\u5e38", e);
        }
    }
}

