/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.rabbitmq;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RabbitmqAspect {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Pointcut(value="@annotation(org.springframework.amqp.rabbit.annotation.RabbitListener)")
    public void rabbitMqPoint() {
    }

    @Around(value="rabbitMqPoint()")
    public void afterRun(JoinPoint joinPoint) {
        block7: {
            try {
                ((ProceedingJoinPoint)joinPoint).proceed();
            }
            catch (Throwable throwable) {
                this.logger.error(throwable.getMessage(), throwable);
                if (null == joinPoint.getArgs()) break block7;
                Message message = null;
                Channel channel = null;
                for (Object obj : joinPoint.getArgs()) {
                    if (obj instanceof Message) {
                        message = (Message)obj;
                        continue;
                    }
                    if (!(obj instanceof Channel)) continue;
                    channel = (Channel)obj;
                }
                try {
                    if (null != message && null != channel) {
                        channel.basicNack(message.getMessageProperties().getDeliveryTag(), false, false);
                    }
                }
                catch (IOException e) {
                    this.logger.error("\u8fde\u63a5rabbitmq\u901a\u9053\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                }
            }
        }
    }
}

