/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.dispatch;

import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.dispatch.DispatchExpressionEvaluator;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class BeanDispatcher {
    private Logger logger = LoggerFactory.getLogger(BeanDispatcher.class);
    private ConcurrentHashMap<Class, Map<Long, Object>> tenantCaches = new ConcurrentHashMap();
    private DispatchExpressionEvaluator evaluator = new DispatchExpressionEvaluator();
    @Autowired
    private ApplicationContext applicationContext;
    @Value(value="#{${xforce.tenantCode}}")
    private Map<Long, String> tenantCode;

    public <T> T dispatch(Long tenantId, Class<T> tClass) {
        Map<Object, Object> serviceMap = new HashMap();
        if (this.tenantCaches.containsKey(tClass)) {
            serviceMap = this.tenantCaches.get(tClass);
        }
        if (serviceMap.containsKey(tenantId)) {
            return (T)serviceMap.get(tenantId);
        }
        Map maps = this.applicationContext.getBeansOfType(tClass);
        Object defaultService = maps.values().stream().filter(bean -> {
            Dispatch dispatch = (Dispatch)AnnotationUtils.findAnnotation(bean.getClass(), Dispatch.class);
            if (dispatch == null) {
                return false;
            }
            return dispatch.isDefault();
        }).findFirst().orElse(null);
        Object service = maps.values().stream().filter(bean -> {
            Dispatch dispatch = (Dispatch)AnnotationUtils.findAnnotation(bean.getClass(), Dispatch.class);
            if (dispatch == null) {
                return false;
            }
            return dispatch.tenantCode().equals(this.tenantCode.get(tenantId));
        }).findFirst().orElse(null);
        if (service == null) {
            service = defaultService;
        }
        serviceMap.put(tenantId, service);
        this.tenantCaches.put(tClass, serviceMap);
        if (service != null) {
            this.logger.debug("tenantId\u3010{}\u3011\u5206\u914d\u5230service\u3010{}\u3011", (Object)tenantId, (Object)service.getClass().getName());
        } else {
            this.logger.error("tenantId\u3010{}\u3011\u672a\u5206\u914d\u5230service", (Object)tenantId);
        }
        return (T)service;
    }

    public <T> T dispatch(Object payload, Class<T> tClass) {
        Map maps = this.applicationContext.getBeansOfType(tClass);
        return maps.values().stream().filter(bean -> {
            Dispatch dispatch = (Dispatch)AnnotationUtils.findAnnotation(bean.getClass(), Dispatch.class);
            if (dispatch == null || ValidatorUtil.isEmpty(dispatch.condition())) {
                return false;
            }
            return this.evaluator.condition(dispatch.condition(), payload);
        }).findFirst().orElse(null);
    }
}

