/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.help.pdf;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Writer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Base64;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class BarCodeUtil {
    public static String getCode(String number) {
        BufferedImage image = BarCodeUtil.getBarCode(number);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        byte[] bytes = out.toByteArray();
        return "data:image/png;base64," + Base64.getEncoder().encodeToString(bytes).trim();
    }

    public static BufferedImage getBarCode(String number) {
        HashMap<EncodeHintType, Integer> hints = new HashMap<EncodeHintType, Integer>();
        hints.put(EncodeHintType.MARGIN, 0);
        int width = new Code128Writer().encode(number).length * 3;
        int height = 75;
        int codeMultiples = 1;
        int codeWidth = width * codeMultiples;
        try {
            BitMatrix bitMatrix = new MultiFormatWriter().encode(number, BarcodeFormat.CODE_128, codeWidth, height);
            return MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        String code = BarCodeUtil.getCode("INA200815511583SK");
        System.out.println(code);
    }
}

