/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.help.pdf;

import com.lowagie.text.DocumentException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;
import org.xhtmlrenderer.pdf.ITextFontResolver;
import org.xhtmlrenderer.pdf.ITextRenderer;

@Component
public class PdfUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected ResourceLoader resourceLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream createPdf(String content) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ITextRenderer render = new ITextRenderer();
        ITextFontResolver fontResolver = render.getFontResolver();
        try {
            fontResolver.addFont("/template/simhei.ttf", "Identity-H", false);
        }
        catch (DocumentException var16) {
            var16.printStackTrace();
        }
        catch (IOException var17) {
            var17.printStackTrace();
        }
        render.setDocumentFromString(content);
        render.layout();
        try {
            ByteArrayOutputStream var4;
            render.createPDF((OutputStream)outStream);
            ByteArrayOutputStream byteArrayOutputStream = var4 = outStream;
            return byteArrayOutputStream;
        }
        catch (DocumentException var18) {
            var18.printStackTrace();
        }
        finally {
            try {
                outStream.close();
            }
            catch (IOException var15) {
                var15.printStackTrace();
            }
        }
        return null;
    }

    public void yPic(List<BufferedImage> piclist, OutputStream os) {
        if (piclist == null || piclist.size() <= 0) {
            System.out.println("\u56fe\u7247\u6570\u7ec4\u4e3a\u7a7a!");
            return;
        }
        int rows = piclist.size();
        int cols = 1;
        try {
            BufferedImage[] buffImages = new BufferedImage[piclist.size()];
            for (int i = 0; i < piclist.size(); ++i) {
                buffImages[i] = piclist.get(i);
            }
            int type = buffImages[0].getType();
            int chunkWidth = buffImages[0].getWidth();
            int chunkHeight = buffImages[0].getHeight();
            BufferedImage finalImg = new BufferedImage(chunkWidth * cols, chunkHeight * rows, type);
            int num = 0;
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    finalImg.createGraphics().drawImage((Image)buffImages[num], chunkWidth * j, chunkHeight * i, null);
                    ++num;
                }
            }
            this.logger.info("Image concatenated.....");
            ImageIO.write((RenderedImage)finalImg, "png", os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

