/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.check.chain;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.check.chain.CheckCondition;
import com.xforceplus.elephant.basecommon.check.chain.CheckElement;
import com.xforceplus.elephant.basecommon.check.chain.CheckNode;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class CheckChain
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ExpressionParser parser = new SpelExpressionParser();
    public static final CheckNode END = new CheckNode();
    private String category;
    private Map<String, CheckElement> elements;
    private CheckNode start;
    private CheckElement current;

    public CheckChain(String category, Map<String, CheckElement> elements, CheckNode start) {
        this.category = category;
        elements.put("end", END);
        elements.put("", END);
        elements.put(null, END);
        this.elements = elements;
        this.start = start;
    }

    public String getCategory() {
        return this.category;
    }

    public CheckNode nextNode(Map<String, Object> entity) {
        if (this.current == null) {
            this.current = this.start;
            return (CheckNode)this.current;
        }
        if (this.current instanceof CheckNode) {
            String nextCode = ((CheckNode)this.current).getNext();
            this.current = this.elements.get(nextCode);
        } else if (this.current instanceof CheckCondition) {
            String expression = ((CheckCondition)this.current).getExpression();
            try {
                StandardEvaluationContext context = new StandardEvaluationContext();
                context.setVariable("entity", (Object)new JSONObject(entity));
                String nextCode = (String)this.parser.parseExpression(expression).getValue((EvaluationContext)context, String.class);
                this.current = this.elements.get(nextCode);
            }
            catch (Exception e) {
                this.logger.debug("\u89c4\u5219\u5f02\u5e38,expression:{},entity:{},error:{}", new Object[]{expression, entity, e.getMessage()});
                throw new ElephantException(e);
            }
        } else {
            return END;
        }
        if (this.current instanceof CheckNode) {
            return (CheckNode)this.current;
        }
        return this.nextNode(entity);
    }
}

