/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.check;

import com.xforceplus.elephant.basecommon.check.Check;
import com.xforceplus.elephant.basecommon.check.CheckContext;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCheckContext
implements CheckContext {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    Map<String, Map<String, Check>> categoryCheckMaps = new HashMap<String, Map<String, Check>>();

    @Override
    public Map<String, Check> getChecks(String category) {
        Map<String, Check> checkMaps = null;
        if (this.categoryCheckMaps.containsKey(category)) {
            checkMaps = this.categoryCheckMaps.get(category);
        }
        if (checkMaps == null) {
            checkMaps = new HashMap<String, Check>();
        }
        return checkMaps;
    }

    @Override
    public void registry(String category, String checkCode, Check check) {
        Map<String, Check> checkMaps;
        if (!this.categoryCheckMaps.containsKey(category)) {
            this.categoryCheckMaps.put(category, new HashMap());
        }
        if (!(checkMaps = this.categoryCheckMaps.get(category)).containsKey(checkCode)) {
            checkMaps.put(checkCode, check);
            this.logger.debug("category:\u3010{}\u3011checkCode:\u3010{}\u3011\u7531\u3010{}\u3011\u6ce8\u518c\u6210\u529f", new Object[]{category, checkCode, check.getClass().getName()});
            return;
        }
        Check hasRegistry = checkMaps.get(checkCode);
        String errorMessage = String.format("category:%s,checkCode:%s,\u5df2\u88ab%s\u6ce8\u518c\uff0c%s\u6ce8\u518c\u5931\u8d25", category, checkCode, hasRegistry.getClass().getName(), check.getClass().getName());
        throw new ElephantException(errorMessage);
    }
}

