/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.help.image;

import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.help.image.WaterMarkBO;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordMark {
    private static final Logger log = LoggerFactory.getLogger(WordMark.class);
    private static String CSSCOLOR = "#bf8f79";
    private static float ALPHA = 0.4f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage buildGraph2d(WaterMarkBO waterMarkBO) {
        Color markContentColor = Color.gray;
        BufferedImage source = null;
        try {
            URL url = new URL(waterMarkBO.getFileUrl());
            ImageIcon imgIcon = new ImageIcon(url);
            Image theImg = imgIcon.getImage();
            int width = theImg.getWidth(null);
            int height = theImg.getHeight(null);
            source = new BufferedImage(width, height, 1);
            Graphics2D g = source.createGraphics();
            g.setColor(markContentColor);
            g.setBackground(Color.white);
            g.drawImage(theImg, 0, 0, null);
            AttributedCharacterIterator iter = WordMark.buildFont(waterMarkBO.getMarkContent(), waterMarkBO.getFontType(), waterMarkBO.getFontSize());
            Color color = Color.decode(CSSCOLOR);
            g.setColor(color);
            if (null != waterMarkBO.getDegree()) {
                g.rotate(Math.toRadians(waterMarkBO.getDegree().intValue()), (double)source.getWidth() / 2.0, (double)source.getHeight() / 2.0);
            }
            g.setComposite(AlphaComposite.getInstance(10, ALPHA));
            for (int i = 0; i < 9; ++i) {
                for (int j = 0; j < 6; ++j) {
                    g.drawString(iter, width - width * j / 4, height - height * i / 8);
                }
            }
            g.dispose();
        }
        catch (MalformedURLException e) {
            log.error("pic url error");
            BufferedImage bufferedImage = null;
            return bufferedImage;
        }
        finally {
            if (null != source) {
                source.getGraphics().dispose();
            }
        }
        return source;
    }

    private static AttributedCharacterIterator buildFont(String markContent, String fontType, Integer fontSize) {
        AttributedString ats = new AttributedString(markContent);
        Font f = new Font(StringHelp.safeIsEmpty(fontType) ? "\u5b8b\u4f53" : fontType, 0, null == fontSize ? 20 : fontSize);
        ats.addAttribute(TextAttribute.FONT, f, 0, markContent.length());
        AttributedCharacterIterator iter = ats.getIterator();
        return iter;
    }
}

