/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.redislock;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.RedisLockMD5;
import com.xforceplus.elephant.basecommon.help.Md5Utils;
import com.xforceplus.elephant.basecommon.help.RedisUtils;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.redislock.ExpressionEvaluator;
import com.xforceplus.elephant.basecommon.redislock.RedisLockAspect;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.expression.EvaluationContext;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RedisLockMD5Aspect {
    private Logger logger = LoggerFactory.getLogger(RedisLockAspect.class);
    private ExpressionEvaluator<String> evaluator = new ExpressionEvaluator();
    @Autowired
    private RedisUtils redisUtils;

    @Pointcut(value="@annotation(com.xforceplus.elephant.basecommon.annotation.RedisLockMD5)")
    public void redisLockMD5Point() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="redisLockMD5Point()")
    public CommonResponse aroundMethod(JoinPoint joinPoint) throws Throwable {
        String md5;
        boolean isLocked;
        boolean isLockedMD5;
        String lockValue;
        String lockKey;
        CommonResponse object;
        block27: {
            RedisLockMD5 redisLock;
            block26: {
                CommonResponse e2;
                MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
                Method method = methodSignature.getMethod();
                object = null;
                lockKey = null;
                lockValue = null;
                isLockedMD5 = false;
                isLocked = false;
                md5 = "";
                try {
                    Object joinPointArg;
                    String argJson;
                    redisLock = method.getAnnotation(RedisLockMD5.class);
                    if (redisLock == null) {
                        CommonResponse.failed("\u83b7\u53d6redisLock\u5f02\u5e38");
                    }
                    if (joinPoint.getArgs() == null) {
                        CommonResponse.failed("args\u4e3a\u7a7a");
                    }
                    if (!ValidatorUtil.isNotEmpty(md5 = Md5Utils.dedupParamMD5(argJson = JSONObject.toJSONString((Object)(joinPointArg = joinPoint.getArgs()[0])), redisLock.excludeKeys()))) break block26;
                    try {
                        isLockedMD5 = this.redisUtils.tryGetDistributedLockException(md5, md5, redisLock.expireTime(), redisLock.maxRetryTimes(), redisLock.retryIntervalTimeMillis());
                        this.logger.debug("lockMD5============" + isLockedMD5 + "==========md5KEY:" + md5);
                    }
                    catch (Exception e2) {
                        isLockedMD5 = true;
                        this.logger.error("redisLockPoint error", (Throwable)e2);
                    }
                    if (isLockedMD5) break block26;
                    e2 = CommonResponse.failed(redisLock.errorMessage());
                }
                catch (Throwable throwable) {
                    try {
                        if (isLocked) {
                            this.redisUtils.releaseDistributedLock(lockKey, lockValue);
                        }
                        if (isLockedMD5 && ValidatorUtil.isNotEmpty(md5)) {
                            this.redisUtils.releaseDistributedLock(md5, md5);
                        }
                    }
                    catch (Exception e3) {
                        this.logger.error("\u91ca\u653e\u9501\u5931\u8d25");
                    }
                    throw throwable;
                }
                try {
                    if (isLocked) {
                        this.redisUtils.releaseDistributedLock(lockKey, lockValue);
                    }
                    if (isLockedMD5 && ValidatorUtil.isNotEmpty(md5)) {
                        this.redisUtils.releaseDistributedLock(md5, md5);
                    }
                }
                catch (Exception e4) {
                    this.logger.error("\u91ca\u653e\u9501\u5931\u8d25");
                }
                return e2;
            }
            if (!ValidatorUtil.isNotEmpty(redisLock.lockKey()) || !ValidatorUtil.isNotEmpty(redisLock.lockValue())) break block27;
            lockKey = this.getLockKey(joinPoint, redisLock.lockKey());
            lockValue = this.getLockKey(joinPoint, redisLock.lockValue());
            try {
                isLocked = this.redisUtils.tryGetDistributedLockException(lockKey, lockValue, redisLock.expireTime(), redisLock.maxRetryTimes(), redisLock.retryIntervalTimeMillis());
            }
            catch (Exception e) {
                isLocked = true;
                this.logger.error("redisLockPoint error", (Throwable)e);
            }
            if (isLocked) break block27;
            CommonResponse commonResponse = CommonResponse.failed(redisLock.errorMessage());
            try {
                if (isLocked) {
                    this.redisUtils.releaseDistributedLock(lockKey, lockValue);
                }
                if (isLockedMD5 && ValidatorUtil.isNotEmpty(md5)) {
                    this.redisUtils.releaseDistributedLock(md5, md5);
                }
            }
            catch (Exception e) {
                this.logger.error("\u91ca\u653e\u9501\u5931\u8d25");
            }
            return commonResponse;
        }
        object = (CommonResponse)((ProceedingJoinPoint)joinPoint).proceed();
        try {
            if (isLocked) {
                this.redisUtils.releaseDistributedLock(lockKey, lockValue);
            }
            if (isLockedMD5 && ValidatorUtil.isNotEmpty(md5)) {
                this.redisUtils.releaseDistributedLock(md5, md5);
            }
        }
        catch (Exception e) {
            this.logger.error("\u91ca\u653e\u9501\u5931\u8d25");
        }
        return object;
    }

    private String getLockKey(JoinPoint joinPoint, String key) {
        EvaluationContext evaluationContext = this.evaluator.createEvaluationContext(joinPoint.getTarget(), joinPoint.getTarget().getClass(), ((MethodSignature)joinPoint.getSignature()).getMethod(), joinPoint.getArgs());
        AnnotatedElementKey methodKey = new AnnotatedElementKey((AnnotatedElement)((MethodSignature)joinPoint.getSignature()).getMethod(), joinPoint.getTarget().getClass());
        return this.evaluator.condition(key, methodKey, evaluationContext, String.class);
    }
}

