/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.system.paas;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.xforceplus.elephant.basecommon.annotation.LogApi;
import com.xforceplus.elephant.basecommon.enums.log.ReceiverEnum;
import com.xforceplus.elephant.basecommon.enums.log.SenderEnum;
import com.xforceplus.elephant.basecommon.enums.log.SystemTypeEnum;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.log.MyThreadLocal;
import com.xforceplus.elephant.basecommon.system.paas.OrgUtils;
import com.xforceplus.elephant.basecommon.system.paas.PaasTokenUtils;
import com.xforceplus.elephant.basecommon.system.paas.SystemPaasSettings;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompanyUtils {
    private Logger logger = LoggerFactory.getLogger(CompanyUtils.class);
    @Autowired
    private SystemPaasSettings systemPaasSettings;
    @Autowired
    private PaasTokenUtils paasTokenUtils;
    @Autowired
    private OrgUtils orgUtils;

    @LogApi(methodCode="getCompanyNo", methodDescription="\u83b7\u53d6\u516c\u53f8\u7f16\u53f7", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PHOENIX)
    public JSONObject getCompanyNo(Long tenantId, String taxNum) {
        JSONObject result = new JSONObject();
        if (ValidatorUtil.isEmpty(taxNum)) {
            new JSONObject();
        }
        String companyNo = "";
        try {
            MyThreadLocal.setObject(tenantId, taxNum);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("tenantId", String.valueOf(tenantId));
            params.put("taxNum", taxNum);
            JSONArray orgs = this.orgUtils.getOrgs(tenantId, params);
            if (ValidatorUtil.isEmpty(orgs)) {
                return result;
            }
            String companyName = orgs.getJSONObject(0).getString("companyName");
            result.put("companyName", (Object)companyName);
            String orgId = orgs.getJSONObject(0).getString("orgId");
            result.put("orgId", (Object)orgId);
            String url = this.systemPaasSettings.getCompanyNoUrl().replace("{tenantKey}", String.valueOf(tenantId)).replace("{orgKey}", orgId);
            String token = this.paasTokenUtils.getLoginToken();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            headers.put("x-app-token", token);
            this.logger.debug("\u83b7\u53d6\u516c\u53f8\u7f16\u53f7\u5f02\u5e38\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)tenantId, (Object)url);
            String responseStr = HttpUtils.doGet(url, headers, Maps.newHashMap());
            JSONObject jsonObject = JSONObject.parseObject((String)responseStr);
            if (ValidatorUtil.isEmpty((Map)jsonObject) || ValidatorUtil.isEmpty((Map)jsonObject.getJSONObject("result")) || ValidatorUtil.isEmpty(jsonObject.getJSONObject("result").getJSONArray("companyNos"))) {
                return jsonObject;
            }
            companyNo = jsonObject.getJSONObject("result").getJSONArray("companyNos").getString(0);
            result.put("companyNo", (Object)companyNo);
            this.logger.info("companyNo:{}", (Object)companyNo);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u516c\u53f8\u7f16\u53f7\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u83b7\u53d6\u516c\u53f8\u7f16\u53f7\u5f02\u5e38", e);
        }
        return result;
    }
}

