/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.redislock;

import com.xforceplus.elephant.basecommon.annotation.RedisLock;
import com.xforceplus.elephant.basecommon.help.RedisUtils;
import com.xforceplus.elephant.basecommon.redislock.ExpressionEvaluator;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.expression.EvaluationContext;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RedisLockAspect {
    private Logger logger = LoggerFactory.getLogger(RedisLockAspect.class);
    private ExpressionEvaluator<String> evaluator = new ExpressionEvaluator();
    @Autowired
    private RedisUtils redisUtils;

    @Pointcut(value="@annotation(com.xforceplus.elephant.basecommon.annotation.RedisLock)")
    public void redisLockPoint() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Around(value="redisLockPoint()")
    public Object aroundMethod(JoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        Object object = null;
        String lockKey = null;
        String lockValue = null;
        try {
            RedisLock redisLock = method.getAnnotation(RedisLock.class);
            if (redisLock == null) {
                throw new Exception("\u83b7\u53d6redisLock\u5f02\u5e38");
            }
            if (joinPoint.getArgs() == null) {
                Object var8_9 = null;
                if (!ValidatorUtil.isNotEmpty(lockKey)) return var8_9;
                this.redisUtils.releaseDistributedLock(lockKey, lockValue);
                return var8_9;
            }
            lockKey = this.getLockKey(joinPoint, redisLock.lockKey());
            lockValue = this.getLockKey(joinPoint, redisLock.lockValue());
            this.redisUtils.tryGetDistributedLock(lockKey, lockValue, redisLock.expireTime(), redisLock.maxRetryTimes(), redisLock.retryIntervalTimeMillis());
            object = ((ProceedingJoinPoint)joinPoint).proceed();
            if (!ValidatorUtil.isNotEmpty(lockKey)) return object;
        }
        catch (Exception e) {
            this.logger.error("redisLockPoint error", (Throwable)e);
            return object;
        }
        this.redisUtils.releaseDistributedLock(lockKey, lockValue);
        return object;
        finally {
            if (ValidatorUtil.isNotEmpty(lockKey)) {
                this.redisUtils.releaseDistributedLock(lockKey, lockValue);
            }
        }
    }

    private String getLockKey(JoinPoint joinPoint, String key) {
        EvaluationContext evaluationContext = this.evaluator.createEvaluationContext(joinPoint.getTarget(), joinPoint.getTarget().getClass(), ((MethodSignature)joinPoint.getSignature()).getMethod(), joinPoint.getArgs());
        AnnotatedElementKey methodKey = new AnnotatedElementKey((AnnotatedElement)((MethodSignature)joinPoint.getSignature()).getMethod(), joinPoint.getTarget().getClass());
        return this.evaluator.condition(key, methodKey, evaluationContext, String.class);
    }
}

