/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.system.paas;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.LogApi;
import com.xforceplus.elephant.basecommon.enums.log.ReceiverEnum;
import com.xforceplus.elephant.basecommon.enums.log.SenderEnum;
import com.xforceplus.elephant.basecommon.enums.log.SystemTypeEnum;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.log.MainHeader;
import com.xforceplus.elephant.basecommon.log.MyThreadLocal;
import com.xforceplus.elephant.basecommon.system.paas.PaasTokenUtils;
import com.xforceplus.elephant.basecommon.system.paas.SystemPaasSettings;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
public class TenantUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SystemPaasSettings systemPaasSettings;
    @Autowired
    private PaasTokenUtils paasTokenUtils;

    @Cacheable(cacheNames={"tenantDetailCache"}, key="#root.args[0]", unless="#result == null || #result.size() == 0")
    @LogApi(methodCode="getTenantDetail", methodDescription="\u83b7\u53d6\u79df\u6237\u660e\u7ec6", systemType=SystemTypeEnum.IMAGE, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PHOENIX)
    public JSONObject getTenantDetail(Long tenantId) {
        try {
            MainHeader mainHeader = MyThreadLocal.setObject(tenantId, String.valueOf(tenantId));
            String url = this.systemPaasSettings.getTenantDetailUrl().replace("{id}", String.valueOf(tenantId));
            String token = this.paasTokenUtils.getLoginToken();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            headers.put("x-app-token", token);
            this.logger.debug("\u53d1\u8d77\u79df\u6237\u660e\u7ec6\u67e5\u8be2\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)tenantId, (Object)url);
            mainHeader.setMethodUrl(url);
            String responseStr = HttpUtils.doGet(url, headers, null);
            this.logger.debug("\u53d1\u8d77\u79df\u6237\u660e\u7ec6\u67e5\u8be2\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            JSONObject resultObject = JSONObject.parseObject((String)responseStr);
            if (ValidatorUtil.isEmpty((Map)resultObject)) {
                this.logger.warn("\u53d1\u8d77\u79df\u6237\u660e\u7ec6\u67e5\u8be2\u5f02\u5e38");
                throw new ElephantException("\u53d1\u8d77\u79df\u6237\u660e\u7ec6\u67e5\u8be2\u5f02\u5e38", new Object[0]);
            }
            String respCode = resultObject.getString("code");
            String respMsg = resultObject.getString("message");
            if (!"1".equals(respCode)) {
                throw new ElephantException(respMsg, new Object[0]);
            }
            JSONObject result = resultObject.getJSONObject("result");
            if (ValidatorUtil.isNotEmpty((Map)result)) {
                return result;
            }
            return new JSONObject();
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u8d77\u79df\u6237\u660e\u7ec6\u67e5\u8be2\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u53d1\u8d77\u79df\u6237\u660e\u7ec6\u67e5\u8be2\u5f02\u5e38", (Throwable)e, new Object[0]);
        }
    }
}

