/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.file.paas;

import com.xforceplus.elephant.basecommon.file.FileStorage;
import com.xforceplus.tower.file.client.model.Policy;
import com.xforceplus.tower.storage.StorageFactory;
import com.xforceplus.tower.storage.model.UploadFileRequest;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PaasFileUtils
implements FileStorage {
    @Autowired(required=false)
    private StorageFactory storageFactory;
    public static final Long TENANT_ID = 123457L;
    public static final Long USER_ID = 13012341234L;

    @Override
    public String getFileUrl(String key) {
        return this.storageFactory.getPublicFileUrl(USER_ID, TENANT_ID, Long.valueOf(Long.parseLong(key)));
    }

    @Override
    public InputStream getFileInputStream(String key) {
        return this.storageFactory.downloadInputStream(USER_ID, TENANT_ID, Long.valueOf(Long.parseLong(key)), null);
    }

    @Override
    public String uploadFileByInputStream(String key, InputStream content) {
        UploadFileRequest uploadFileRequest = new UploadFileRequest();
        uploadFileRequest.setAppId("elephant");
        uploadFileRequest.setExpires(Integer.valueOf(3650));
        uploadFileRequest.setInputStream(content);
        uploadFileRequest.setFileName(StringUtils.substringAfterLast((String)key, (String)"/"));
        uploadFileRequest.setPolicy(Policy.PUBLIC_POLICY);
        uploadFileRequest.setTenantId(TENANT_ID);
        uploadFileRequest.setUserId(USER_ID);
        uploadFileRequest.setOverwrite(Boolean.valueOf(true));
        uploadFileRequest.setFilePath(StringUtils.substringBeforeLast((String)key, (String)"/"));
        Long fileId = this.storageFactory.uploadByInputStream(uploadFileRequest);
        return String.valueOf(fileId);
    }

    @Override
    public boolean deleteFiles(String ... keys) {
        for (String key : keys) {
            this.storageFactory.deleteFile(TENANT_ID, Long.valueOf(Long.parseLong(key)));
        }
        return true;
    }
}

