/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.help.pdf;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

@Component
public class FreemarkerUtil {
    private Configuration freemarkerConfig;
    @Autowired
    protected ResourceLoader resourceLoader;

    @PostConstruct
    public void initConfig() throws Exception {
        this.freemarkerConfig = new Configuration(Configuration.VERSION_2_3_23);
        this.freemarkerConfig.setClassForTemplateLoading(this.getClass(), "/template/");
    }

    public Template getTemplate(String name) {
        Template temp = null;
        try {
            temp = this.freemarkerConfig.getTemplate(name, "UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printString(String name, Object root) {
        StringWriter out = new StringWriter();
        try {
            Template temp = this.getTemplate(name);
            temp.process(root, (Writer)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return out.toString();
    }
}

