/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.system.paas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.elephant.basecommon.annotation.LogApi;
import com.xforceplus.elephant.basecommon.enums.log.ReceiverEnum;
import com.xforceplus.elephant.basecommon.enums.log.SenderEnum;
import com.xforceplus.elephant.basecommon.enums.log.SystemTypeEnum;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.log.MainHeader;
import com.xforceplus.elephant.basecommon.log.MyThreadLocal;
import com.xforceplus.elephant.basecommon.system.paas.PaasTokenUtils;
import com.xforceplus.elephant.basecommon.system.paas.SystemPaasSettings;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Component;

@Component
public class OrgUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SystemPaasSettings systemPaasSettings;
    @Autowired
    private PaasTokenUtils paasTokenUtils;

    @Caching(cacheable={@Cacheable(cacheNames={"hitOrgCache"}, key="#root.args[0]+':'+#root.args[1]", unless="#result == null || #result.size() == 0"), @Cacheable(cacheNames={"missOrgCache"}, key="#root.args[0]+':'+#root.args[1]", condition="#result == null || #result.size() == 0")})
    public JSONArray getOrgs(Long tenantId, Map<String, String> params) {
        if (ValidatorUtil.isEmpty(params)) {
            return new JSONArray();
        }
        HashMap<String, String> paramMap = new HashMap<String, String>(params);
        paramMap.put("status", "1");
        try {
            MainHeader mainHeader = MyThreadLocal.setObject(tenantId, String.valueOf(tenantId));
            String url = this.systemPaasSettings.getSelectSysOrgUrl().replace("{tenantId}", String.valueOf(tenantId));
            String token = this.paasTokenUtils.getLoginToken();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            headers.put("x-app-token", token);
            this.logger.debug("\u53d1\u8d77\u7ec4\u7ec7\u67e5\u8be2\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, url, JSON.toJSONString(paramMap)});
            mainHeader.setMethodUrl(url);
            String responseStr = HttpUtils.doGet(url, headers, paramMap);
            this.logger.debug("\u53d1\u8d77\u7ec4\u7ec7\u67e5\u8be2\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            JSONObject resultObject = JSONObject.parseObject((String)responseStr);
            if (ValidatorUtil.isEmpty((Map)resultObject)) {
                this.logger.warn("\u53d1\u8d77\u6839\u7ec4\u7ec7\u67e5\u8be2\u5f02\u5e38");
                throw new ElephantException("\u53d1\u8d77\u6839\u7ec4\u7ec7\u67e5\u8be2\u5f02\u5e38", new Object[0]);
            }
            String respCode = resultObject.getString("code");
            String respMsg = resultObject.getString("message");
            if (!"1".equals(respCode)) {
                throw new ElephantException(respMsg, new Object[0]);
            }
            JSONObject result = resultObject.getJSONObject("result");
            if (ValidatorUtil.isNotEmpty((Map)result)) {
                return result.getJSONArray("content");
            }
            return new JSONArray();
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u8d77\u6839\u7ec4\u7ec7\u67e5\u8be2\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u53d1\u8d77\u6839\u7ec4\u7ec7\u67e5\u8be2\u5f02\u5e38", (Throwable)e, new Object[0]);
        }
    }

    @Cacheable(cacheNames={"getCurrentUserOrgIdsRedis"}, key="#root.args[0]+':'+#root.args[1]", unless="#result == null || #result.size() == 0")
    @LogApi(methodCode="getCurrentUserOrgIds", methodDescription="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7\u96c6\u5408", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PHOENIX)
    public List<Long> getCurrentUserOrgIds(Long tenantId, Long userId) {
        ArrayList orgIds = Lists.newArrayList();
        try {
            JSONObject resultobj;
            JSONArray currentOrgsJsonArray;
            MainHeader mainHeader = MyThreadLocal.setObject(tenantId, userId.toString(), userId.toString());
            mainHeader.setMethodUrl(this.systemPaasSettings.getCurrentUserOrgIdsUrl());
            HashMap<String, String> headers = new HashMap<String, String>();
            String token = this.paasTokenUtils.getLoginToken();
            if (ValidatorUtil.isNotEmpty(token)) {
                headers.put("x-app-token", token);
            }
            String url = this.systemPaasSettings.getCurrentUserOrgIdsUrl().replace("{userId}", String.valueOf(userId));
            this.logger.debug("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7\u96c6\u5408\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)tenantId, (Object)url);
            String responseStr = HttpUtils.doGet(url, headers, null);
            this.logger.debug("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7\u96c6\u5408\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            if (ValidatorUtil.isEmpty(responseStr)) {
                this.logger.error("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7\u96c6\u5408\u5f02\u5e38\uff1a{}", (Object)responseStr);
                throw new ElephantException("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7\u96c6\u5408\u5f02\u5e38\uff1a" + responseStr, new Object[0]);
            }
            JSONObject resultJson = JSONObject.parseObject((String)responseStr);
            if (ValidatorUtil.isEmpty((Map)resultJson)) {
                return orgIds;
            }
            String code = resultJson.getString("code");
            if ("1".equals(code) && ValidatorUtil.isNotEmpty(currentOrgsJsonArray = (resultobj = resultJson.getJSONObject("result")).getJSONArray("currentOrgs"))) {
                for (int i = 0; i < currentOrgsJsonArray.size(); ++i) {
                    JSONObject contentObj = JSONObject.parseObject((String)currentOrgsJsonArray.get(i).toString());
                    String orgId = contentObj.getString("orgId");
                    if (!ValidatorUtil.isNotEmpty(orgId)) continue;
                    orgIds.add(Long.valueOf(orgId));
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7\u96c6\u5408\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7\u96c6\u5408\u5f02\u5e38", (Throwable)e, new Object[0]);
        }
        return orgIds;
    }

    @Cacheable(cacheNames={"getUsersExtraInfo"}, key="#root.args[0]+':'+#root.args[1]", unless="#result == null || #result.size() == 0")
    @LogApi(methodCode="getUsersExtraInfo", methodDescription="\u83b7\u53d6\u7528\u6237\u7ec4\u7ec7\u8be6\u60c5", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PHOENIX)
    public JSONObject getUsersExtraInfo(Long tenantId, Long userId, Integer extraInfo) {
        ArrayList orgIds = Lists.newArrayList();
        try {
            MainHeader mainHeader = MyThreadLocal.setObject(tenantId, userId.toString(), userId.toString());
            mainHeader.setMethodUrl(this.systemPaasSettings.getUserExtraInfoUrl());
            HashMap<String, String> headers = new HashMap<String, String>();
            String token = this.paasTokenUtils.getLoginToken();
            if (ValidatorUtil.isNotEmpty(token)) {
                headers.put("x-app-token", token);
            }
            HashMap params = Maps.newHashMap();
            params.put("extraInfo", extraInfo.toString());
            String url = this.systemPaasSettings.getUserExtraInfoUrl().replace("{userId}", String.valueOf(userId));
            String responseStr = HttpUtils.doGet(url, headers, params);
            if (ValidatorUtil.isEmpty(responseStr)) {
                this.logger.error("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7\u96c6\u5408\u5f02\u5e38\uff1a{}", (Object)responseStr);
                throw new ElephantException("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7\u96c6\u5408\u5f02\u5e38\uff1a" + responseStr, new Object[0]);
            }
            JSONObject resultJson = JSONObject.parseObject((String)responseStr);
            return resultJson;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7\u96c6\u5408\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7\u96c6\u5408\u5f02\u5e38", (Throwable)e, new Object[0]);
        }
    }
}

