/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.system.paas;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.LogApi;
import com.xforceplus.elephant.basecommon.enums.common.YesOrNoEnum;
import com.xforceplus.elephant.basecommon.enums.log.ReceiverEnum;
import com.xforceplus.elephant.basecommon.enums.log.SenderEnum;
import com.xforceplus.elephant.basecommon.enums.log.SystemTypeEnum;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.log.MainHeader;
import com.xforceplus.elephant.basecommon.log.MyThreadLocal;
import com.xforceplus.elephant.basecommon.system.paas.PaasTokenUtils;
import com.xforceplus.elephant.basecommon.system.paas.SystemPaasSettings;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ConvertFileUtils {
    private Logger logger = LoggerFactory.getLogger(ConvertFileUtils.class);
    @Autowired
    private SystemPaasSettings systemPaasSettings;
    @Autowired
    private PaasTokenUtils paasTokenUtils;
    @Value(value="#{${xforce.convertFile:{}}}")
    private Map<String, String> paramsMap;
    private final String OSS_REGEX = "^https?://(.+)\\.oss-cn-hangzhou\\.aliyuncs\\.com(.+)$";

    @LogApi(methodCode="covertFile", methodDescription="file\u8f6c\u56fe\u7247", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.MELETE)
    public String covertFile(Long tenantId, String tenantCode, String filePath, String fileSuffix, String title) {
        MainHeader mainHeader = MyThreadLocal.setObject(tenantId, filePath);
        if (ValidatorUtil.isEmpty(tenantId) || ValidatorUtil.isEmpty(tenantCode) || ValidatorUtil.isEmpty(filePath) || ValidatorUtil.isEmpty(title)) {
            return "";
        }
        Pattern pattern = Pattern.compile("^https?://(.+)\\.oss-cn-hangzhou\\.aliyuncs\\.com(.+)$");
        Matcher ossMatcher = pattern.matcher(filePath);
        String bucketName = "";
        String key = "";
        if (ossMatcher.find()) {
            bucketName = ossMatcher.group(1);
            key = ossMatcher.group(2);
        }
        if (ValidatorUtil.isEmpty(bucketName) || ValidatorUtil.isEmpty(key)) {
            return "";
        }
        String url = this.systemPaasSettings.getFileTranFormAsync().replace("{tenantId}", String.valueOf(tenantId));
        String token = this.paasTokenUtils.getLoginToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("x-app-token", token);
        JSONObject bodyJson = new JSONObject();
        bodyJson.put("file", (Object)filePath);
        bodyJson.put("title", (Object)title);
        bodyJson.put("group", (Object)tenantCode);
        bodyJson.put("scene", (Object)0);
        bodyJson.put("fileSuffix", (Object)fileSuffix);
        bodyJson.put("callbackUrl", (Object)this.systemPaasSettings.getPdfCallbackUrl());
        bodyJson.put("customerNo", (Object)("fileTransform_" + System.getProperty("env")));
        bodyJson.put("bucket", (Object)bucketName);
        bodyJson.put("object", (Object)key);
        bodyJson.put("regionId", (Object)"cn-hangzhou");
        bodyJson.putAll(this.paramsMap);
        this.logger.debug("covertFile bodyJson:{}", (Object)bodyJson.toJSONString());
        String responseStr = HttpUtils.doJsonPost(url, headers, bodyJson.toJSONString());
        if (StringUtils.isBlank((CharSequence)responseStr)) {
            mainHeader.fail("file\u6587\u4ef6\u8f6c\u56fe\u7247\u5f02\u5e38\uff0c\u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a", responseStr);
            return "";
        }
        JSONObject jsonObject = JSONObject.parseObject((String)responseStr);
        int code = jsonObject.getIntValue("code");
        if (YesOrNoEnum.YES.getCode().equals(code)) {
            return jsonObject.getJSONObject("result").getString("taskId");
        }
        mainHeader.fail(jsonObject.getString("message"), responseStr);
        return "";
    }
}

