/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.file.minio;

import com.xforceplus.elephant.basecommon.file.FileStorage;
import com.xforceplus.elephant.basecommon.file.minio.MinioSettings;
import io.minio.MinioClient;
import java.io.FileInputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MinioUtils
implements FileStorage {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private MinioClient minioClient;
    private MinioSettings minioSettings;

    @Autowired
    public void setMinioSettings(MinioSettings minioSettings) throws Exception {
        if (minioSettings == null || minioSettings.getUrl() == null || minioSettings.getAccessKey() == null || minioSettings.getSecretKey() == null) {
            return;
        }
        if (this.minioSettings != null) {
            return;
        }
        this.minioSettings = minioSettings;
        this.minioClient = new MinioClient(minioSettings.getUrl(), minioSettings.getAccessKey(), minioSettings.getSecretKey());
        if (!this.minioClient.bucketExists(minioSettings.getBucketName())) {
            this.minioClient.makeBucket(minioSettings.getBucketName());
        }
    }

    @Override
    public String getFileUrl(String key) {
        throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301");
    }

    @Override
    public InputStream getFileInputStream(String key) {
        try {
            return this.minioClient.getObject(this.minioSettings.getBucketName(), key);
        }
        catch (Exception e) {
            this.logger.error("minio\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    @Override
    public String uploadFileByInputStream(String key, InputStream content) {
        try {
            long size = content.available();
            this.minioClient.putObject(this.minioSettings.getBucketName(), key, content, Long.valueOf(size), null, null, null);
        }
        catch (Exception e) {
            this.logger.error("minio\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
        }
        return key;
    }

    @Override
    public boolean deleteFiles(String ... keys) {
        try {
            for (String key : keys) {
                this.minioClient.removeObject(this.minioSettings.getBucketName(), key);
            }
            return true;
        }
        catch (Exception e) {
            this.logger.error("minio\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        MinioClient minioClient = new MinioClient("http://minio.fapiao.vanke.com", "AKIAIOSFODNN7EXAMPLE", "wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY");
        try (FileInputStream is = new FileInputStream("E:\\Downloads\\upupooV2.0.exe");){
            long size = ((InputStream)is).available();
            minioClient.putObject("prod", "vanke/upupooV2.0.exe", (InputStream)is, Long.valueOf(size), null, null, null);
        }
    }
}

