/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.help;

import com.xforceplus.elephant.basecommon.exception.ElephantException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class OkHttpUtils {
    private static OkHttpClient okHttpClient;

    @Value(value="${httpTimeOut:10}")
    public static void createClient(int timeout) {
        okHttpClient = new OkHttpClient.Builder().connectTimeout((long)timeout, TimeUnit.SECONDS).readTimeout((long)timeout, TimeUnit.SECONDS).writeTimeout((long)timeout, TimeUnit.SECONDS).build();
    }

    public static OKRequestBuilder get(String url) {
        return new OKRequestBuilder().get(url);
    }

    public static OKRequestBuilder post(String url) {
        return new OKRequestBuilder().post(url);
    }

    public static OKRequestBuilder put(String url) {
        return new OKRequestBuilder().put(url);
    }

    public static OKRequestBuilder delete(String url) {
        return new OKRequestBuilder().delete(url);
    }

    public static OKRequestBuilder head(String url) {
        return new OKRequestBuilder().head(url);
    }

    public static OKRequestBuilder patch(String url) {
        return new OKRequestBuilder().patch(url);
    }

    static {
        OkHttpUtils.createClient(10);
    }

    public static class OKRequestBuilder {
        public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
        OkHttpClient privateHttpClient = OkHttpUtils.access$600();
        Request.Builder requestBuilder = new Request.Builder();
        RequestBody body;
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        String method;
        Response response;

        public OKRequestBuilder timeout(long timeout) {
            this.privateHttpClient = okHttpClient.newBuilder().connectTimeout(timeout, TimeUnit.MILLISECONDS).readTimeout(timeout, TimeUnit.MILLISECONDS).writeTimeout(timeout, TimeUnit.MILLISECONDS).build();
            return this;
        }

        private OKRequestBuilder get(String url) {
            this.requestBuilder.url(url).get();
            return this;
        }

        private OKRequestBuilder post(String url) {
            this.requestBuilder.url(url);
            this.method = "POST";
            return this;
        }

        private OKRequestBuilder put(String url) {
            this.requestBuilder.url(url);
            this.method = "PUT";
            return this;
        }

        private OKRequestBuilder delete(String url) {
            this.requestBuilder.url(url);
            this.method = "DELETE";
            return this;
        }

        private OKRequestBuilder head(String url) {
            this.requestBuilder.url(url).head();
            return this;
        }

        private OKRequestBuilder patch(String url) {
            this.requestBuilder.url(url);
            this.method = "PATCH";
            return this;
        }

        public OKRequestBuilder header(String name, String value) {
            this.requestBuilder.header(name, value);
            return this;
        }

        public OKRequestBuilder header(Map<String, String> headers) {
            headers.entrySet().forEach(entry -> this.requestBuilder.header((String)entry.getKey(), (String)entry.getValue()));
            return this;
        }

        public OKRequestBuilder body(String json) {
            if (this.method == null) {
                return this;
            }
            this.body = RequestBody.create((MediaType)JSON, (String)json);
            return this;
        }

        public OKRequestBuilder params(String name, String value) {
            if (this.method == null) {
                HttpUrl.Builder urlBuilder = this.requestBuilder.build().url().newBuilder();
                urlBuilder.addQueryParameter(name, value);
                this.requestBuilder.url(urlBuilder.build());
                return this;
            }
            this.bodyBuilder.addFormDataPart(name, value);
            return this;
        }

        public OKRequestBuilder params(Map<String, String> params) {
            if (this.method == null) {
                HttpUrl.Builder urlBuilder = this.requestBuilder.build().url().newBuilder();
                params.entrySet().forEach(entry -> urlBuilder.addQueryParameter((String)entry.getKey(), (String)entry.getValue()));
                this.requestBuilder.url(urlBuilder.build());
                return this;
            }
            params.entrySet().forEach(entry -> this.bodyBuilder.addFormDataPart((String)entry.getKey(), (String)entry.getValue()));
            return this;
        }

        public OKRequestBuilder file(String name, String fileName, final InputStream inputStream) {
            if (this.method == null) {
                return this;
            }
            RequestBody file = new RequestBody(){

                public void writeTo(@NotNull BufferedSink bufferedSink) throws IOException {
                    Source source = null;
                    try {
                        source = Okio.source((InputStream)inputStream);
                        bufferedSink.writeAll(source);
                    }
                    finally {
                        Util.closeQuietly((Closeable)source);
                    }
                }

                public long contentLength() {
                    try {
                        return inputStream.available();
                    }
                    catch (IOException e) {
                        return 0L;
                    }
                }

                @Nullable
                public MediaType contentType() {
                    return MediaType.parse((String)"File/*");
                }
            };
            this.bodyBuilder.addFormDataPart(name, fileName, file);
            return this;
        }

        private void execute() {
            if (this.method != null) {
                if (this.body == null) {
                    this.body = this.bodyBuilder.build();
                }
                this.requestBuilder.method(this.method, this.body);
            }
            try {
                this.response = this.privateHttpClient.newCall(this.requestBuilder.build()).execute();
            }
            catch (IOException e) {
                throw new ElephantException("\u8bf7\u6c42\u65f6\u5f02\u5e38", (Throwable)e, new Object[0]);
            }
        }

        public String string() {
            this.execute();
            try {
                return this.response.body().string();
            }
            catch (IOException e) {
                throw new ElephantException("\u83b7\u53d6\u7ed3\u679c\u65f6\u5f02\u5e38", (Throwable)e, new Object[0]);
            }
        }

        public InputStream stream() {
            this.execute();
            return this.response.body().byteStream();
        }

        public Response response() {
            this.execute();
            return this.response;
        }
    }
}

