/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.help.image;

import com.xforceplus.elephant.basecommon.help.image.WaterMarkBO;
import com.xforceplus.elephant.basecommon.help.image.WordMark;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.Coordinate;
import net.coobird.thumbnailator.geometry.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtils {
    private static Logger log = LoggerFactory.getLogger(ImageUtils.class);

    public static void main(String[] args) {
        String srcFile = "http://imsc-prod-files.oss-cn-hangzhou.aliyuncs.com/melete-scan/PROD/123456781234567/20210226-15/e88b09f13a2c46a5b12fc7217cd19a8e.jpg";
        OutputStream out = null;
        ImageUtils.waterMarkWord(out, new WaterMarkBO(srcFile, "\u7968\u6613\u901a111", null, null, null));
    }

    public static final boolean scale(String srcFile, String distFile, double scale) {
        try {
            Thumbnails.of((String[])new String[]{srcFile}).scale(scale).toFile(distFile);
            return true;
        }
        catch (IOException e) {
            log.error("\u56fe\u7247\u5904\u7406\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public static final boolean scale(String srcFile, String distFile, int width, int height) {
        try {
            Thumbnails.of((String[])new String[]{srcFile}).scale((double)width, (double)height).toFile(distFile);
            return true;
        }
        catch (IOException e) {
            log.error("\u56fe\u7247\u5904\u7406\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public static final boolean cut(String srcFile, String distFile, int x, int y, int width, int height) {
        try {
            Thumbnails.of((String[])new String[]{srcFile}).sourceRegion(x, y, width, height).toFile(distFile);
            return true;
        }
        catch (IOException e) {
            log.error("\u56fe\u7247\u5904\u7406\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public static final boolean waterMarkImg(String pressImg, String srcFile, String distFile, int x, int y, float alpha) {
        try {
            Thumbnails.of((String[])new String[]{srcFile}).scale(1.0).watermark((Position)new Coordinate(x, y), ImageIO.read(new File(pressImg)), alpha).toFile(distFile);
            return true;
        }
        catch (IOException e) {
            log.error("\u56fe\u7247\u5904\u7406\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void waterMarkWord(OutputStream out, WaterMarkBO bo) {
        BufferedImage source = null;
        try {
            source = WordMark.buildGraph2d(bo);
            ImageIO.write((RenderedImage)source, "JPG", out);
        }
        catch (IOException iOException) {
        }
        finally {
            if (source != null) {
                source.getGraphics().dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void waterMarkWord(String distFile, WaterMarkBO bo) {
        BufferedImage source = null;
        try {
            source = WordMark.buildGraph2d(bo);
            File targetFile = new File(distFile);
            if (!targetFile.getParentFile().exists()) {
                targetFile.getParentFile().mkdirs();
            }
            ImageIO.write((RenderedImage)source, "JPG", new File(distFile));
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (source != null) {
                source.getGraphics().dispose();
            }
        }
    }

    public static String getImageFormatName(File file) throws IOException {
        String formatName = null;
        ImageInputStream iis = ImageIO.createImageInputStream(file);
        Iterator<ImageReader> imageReader = ImageIO.getImageReaders(iis);
        if (imageReader.hasNext()) {
            ImageReader reader = imageReader.next();
            formatName = reader.getFormatName();
        }
        return formatName;
    }

    public static boolean compressImage(File srcFile, File distFile) throws IOException {
        try {
            Thumbnails.of((File[])new File[]{srcFile}).scale(1.0).outputQuality(0.1f).toFile(distFile);
            return true;
        }
        catch (IOException e) {
            log.error("\u56fe\u7247\u5904\u7406\u5931\u8d25", (Throwable)e);
            return false;
        }
    }
}

