/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.log;

import com.alibaba.fastjson.JSON;
import com.xforceplus.elephant.basecommon.annotation.LogApi;
import com.xforceplus.elephant.basecommon.enums.common.YesOrNoEnum;
import com.xforceplus.elephant.basecommon.enums.log.IsSuccessEnum;
import com.xforceplus.elephant.basecommon.help.JsonHelp;
import com.xforceplus.elephant.basecommon.log.LogApiEntity;
import com.xforceplus.elephant.basecommon.log.MainHeader;
import com.xforceplus.elephant.basecommon.log.MyThreadLocal;
import com.xforceplus.elephant.basecommon.rabbitmq.RabbitmqUtils;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Aspect
@Component
public class LogAspect {
    private Logger logger = LoggerFactory.getLogger(LogAspect.class);
    @Resource
    HttpServletRequest httpServletRequest;
    @Autowired(required=false)
    private RabbitmqUtils rabbitmqUtils;

    @Pointcut(value="@annotation(com.xforceplus.elephant.basecommon.annotation.LogApi)")
    public void logPoint() {
    }

    @Around(value="logPoint()")
    public Object aroundMethod(JoinPoint joinPoint) throws Throwable {
        StopWatch stopWatch = new StopWatch(joinPoint.getSignature().getName());
        LogApiEntity logApiEntity = new LogApiEntity();
        String params = JSON.toJSONString((Object)joinPoint.getArgs());
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        LogApi logApi = method.getAnnotation(LogApi.class);
        logApiEntity.setCreateTime(new Date());
        logApiEntity.setCreateUser("\u7cfb\u7edf");
        logApiEntity.setMethodName(method.getName());
        logApiEntity.setMethodDescription(logApi.methodDescription());
        if ("syncImageUploadInfo".equals(logApi.methodCode())) {
            params = String.valueOf(params.length());
        }
        logApiEntity.setParams(params);
        logApiEntity.setSender(logApi.sender().getCode());
        logApiEntity.setReceiver(logApi.receiver().getCode());
        logApiEntity.setMethodCode(logApi.methodCode());
        logApiEntity.setSystemType(logApi.systemType().getCode());
        logApiEntity.setIsRetry(logApi.isRetry());
        logApiEntity.setExceptionDetail("");
        logApiEntity.setMethodType(logApi.methodType().getCode());
        logApiEntity.setIsSuccess(IsSuccessEnum.SUCCESS.getCode());
        logApiEntity.setIsSuccessful(YesOrNoEnum.YES.getCode());
        try {
            logApiEntity.setMethodUrl(this.httpServletRequest.getRequestURI());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object = null;
        MainHeader mainHeader = null;
        try {
            stopWatch.start();
            object = ((ProceedingJoinPoint)joinPoint).proceed();
            stopWatch.stop();
            if (object instanceof String) {
                logApiEntity.setResult((String)object);
            } else {
                logApiEntity.setResult(JsonHelp.toString(object));
            }
            logApiEntity.setExecutionTime(Long.toString(stopWatch.getTotalTimeMillis()));
            mainHeader = MyThreadLocal.getObject();
            MyThreadLocal.removeObject();
            if (mainHeader != null) {
                logApiEntity.setTenantId(mainHeader.getTenantId());
                logApiEntity.setNumber(mainHeader.getNumber());
                logApiEntity.setBillCode(mainHeader.getBillCode());
                logApiEntity.setInvoiceNo(mainHeader.getInvoiceNo());
                logApiEntity.setInvoiceCode(mainHeader.getInvoiceCode());
                if (mainHeader.getIsSuccess() == IsSuccessEnum.FAIL) {
                    logApiEntity.setIsSuccess(IsSuccessEnum.FAIL.getCode());
                    logApiEntity.setIsSuccessful(YesOrNoEnum.NO.getCode());
                    logApiEntity.setResult(mainHeader.getResult());
                    logApiEntity.setExceptionDetail(mainHeader.getErrorMessage());
                }
            }
        }
        catch (Throwable e) {
            mainHeader = MyThreadLocal.getObject();
            logApiEntity.setTenantId(mainHeader.getTenantId());
            logApiEntity.setNumber(mainHeader.getNumber());
            logApiEntity.setBillCode(mainHeader.getBillCode());
            logApiEntity.setInvoiceNo(mainHeader.getInvoiceNo());
            logApiEntity.setInvoiceCode(mainHeader.getInvoiceCode());
            logApiEntity.setIsSuccess(IsSuccessEnum.FAIL.getCode());
            logApiEntity.setIsSuccessful(YesOrNoEnum.NO.getCode());
            try (StringWriter stringWriter = new StringWriter();
                 PrintWriter printWriter = new PrintWriter(stringWriter);){
                e.printStackTrace(printWriter);
                StringBuffer buffer = stringWriter.getBuffer();
                logApiEntity.setExceptionDetail(buffer.toString());
            }
            throw e;
        }
        finally {
            if (mainHeader != null && ValidatorUtil.isNotEmpty(mainHeader.getMethodUrl())) {
                logApiEntity.setMethodUrl(mainHeader.getMethodUrl());
            }
            MyThreadLocal.removeObject();
            if (null != this.rabbitmqUtils) {
                this.rabbitmqUtils.sendByDirectExchange("imageApiLogQueue", logApiEntity);
            }
        }
        return object;
    }
}

