/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.log;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.help.DateHelp;
import com.xforceplus.elephant.basecommon.log.LogMqEntity;
import com.xforceplus.elephant.basecommon.rabbitmq.RabbitmqUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LogMqUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogMqUtils.class);
    @Autowired(required=false)
    private RabbitmqUtils rabbitmqUtils;

    public void addMQLogData(String billCode, String ticketCode, String queueName, String queueDesc, String sender, String listener, Message message, Integer isSucess, String error, Date receiveTime) {
        LogMqEntity entity = new LogMqEntity();
        entity.setBillCode(billCode);
        entity.setTicketCode(ticketCode);
        entity.setQueueName(queueName);
        entity.setQueueDesc(queueDesc);
        entity.setSender(sender);
        entity.setListener(listener);
        if (message.getMessageProperties().getHeaders().size() > 0) {
            entity.setProperties(JSONObject.toJSONString((Object)message.getMessageProperties().getHeaders()));
        }
        entity.setMessage(new String(message.getBody()));
        entity.setStatus(isSucess);
        entity.setError(error);
        entity.setReceiveTime(receiveTime);
        entity.setFinishTime(DateHelp.getNowDate());
        LOGGER.debug("addMQLogData\u6d88\u606f\u53d1\u9001...");
        if (null != this.rabbitmqUtils) {
            this.rabbitmqUtils.sendByDirectExchange("imageMQLogQueue", entity);
        }
    }
}

