/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.rabbitmq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.GetResponse;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.rabbitmq.entity.MqMessageEntity;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;

public class RabbitmqUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired(required=false)
    private RabbitTemplate rabbitTemplate;

    public void sendByDirectExchange(String routingKey, Object msg) {
        this.send("directExchange", routingKey, msg, null);
    }

    public void sendByDirectExchange(String routingKey, Object msg, Map<String, Object> headers) {
        this.send("directExchange", routingKey, msg, headers);
    }

    public void sendByTopicExchange(String routingKey, Object msg) {
        this.send("topicExchange", routingKey, msg, null);
    }

    public void sendByTopicExchange(String routingKey, Object msg, Map<String, Object> headers) {
        this.send("topicExchange", routingKey, msg, headers);
    }

    public void sendByFanoutExchange(Object msg) {
        this.send("fanoutExchange", null, msg, null);
    }

    public void sendByFanoutExchange(Object msg, Map<String, Object> headers) {
        this.send("fanoutExchange", null, msg, headers);
    }

    public void send(String exchange, String routingKey, Object msg, Map<String, Object> headers) {
        MessageProperties messageProperties = new MessageProperties();
        if (null != headers) {
            messageProperties.getHeaders().putAll(headers);
        }
        String jsonMsg = null;
        jsonMsg = msg instanceof String ? (String)msg : JSON.toJSONString((Object)msg);
        this.logger.debug("send mq queue:{},msg:{}", (Object)routingKey, (Object)jsonMsg);
        Message message = new Message(jsonMsg.getBytes(), messageProperties);
        this.rabbitTemplate.convertAndSend(exchange, routingKey, (Object)message);
    }

    public void send(String exchange, String routingKey, Object msg, Integer priority, String expires) {
        String jsonMsg = null;
        jsonMsg = msg instanceof String ? (String)msg : JSON.toJSONString((Object)msg);
        this.rabbitTemplate.convertAndSend(exchange, routingKey, (Object)jsonMsg, message -> {
            if (null != priority) {
                message.getMessageProperties().setPriority(priority);
            }
            if (null != expires) {
                message.getMessageProperties().setExpiration(expires);
            }
            return message;
        });
    }

    public List<MqMessageEntity> getMessageList(Integer num, String queueName) {
        ArrayList resultList = Lists.newArrayList();
        Connection connection = null;
        Channel channel = null;
        try {
            ConnectionFactory connectionFactory = this.rabbitTemplate.getConnectionFactory();
            connection = connectionFactory.createConnection();
            channel = connection.createChannel(true);
            Integer count = this.getMessageCount(channel, queueName);
            if (count < num) {
                num = count;
            }
            Long tag = 0L;
            while (num > 0) {
                MqMessageEntity entity = new MqMessageEntity();
                GetResponse response = channel.basicGet(queueName, false);
                entity.setIndexId(resultList.size() + 1);
                entity.setMessage(new String(response.getBody()).replaceAll("\\\\", ""));
                entity.setDeliveryTag(response.getEnvelope().getDeliveryTag());
                if (response.getProps() != null && response.getProps().getHeaders() != null) {
                    Map props = response.getProps().getHeaders();
                    HashMap tempProp = Maps.newHashMap();
                    props.entrySet().stream().forEach(r -> {
                        if (((String)r.getKey()).equals("x-first-death-exchange") && r.getValue() != null) {
                            entity.setExchange(new String(r.getValue().toString()));
                        } else if (((String)r.getKey()).equals("x-first-death-queue") && r.getValue() != null) {
                            entity.setQueueName(new String(r.getValue().toString()));
                        } else if (((String)r.getKey()).equals("x-death") && r.getValue() != null) {
                            String str = r.getValue().toString();
                            if (!ValidatorUtil.isEmpty(str = str.substring(str.indexOf("time=") + 5, str.indexOf("routing-keys") - 2))) {
                                try {
                                    SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.ENGLISH);
                                    entity.setCreateTime(sdf.parse(str).getTime());
                                }
                                catch (ParseException e) {
                                    e.printStackTrace();
                                }
                            }
                        } else if (!((String)r.getKey()).equals("x-first-death-reason")) {
                            tempProp.put(r.getKey(), new String(r.getValue().toString().replaceAll("\\\\", "")));
                        }
                    });
                    if (null != tempProp && tempProp.size() > 0) {
                        entity.setProperties(JSONObject.toJSONString((Object)tempProp));
                    }
                }
                resultList.add(entity);
                tag = response.getEnvelope().getDeliveryTag();
                Integer n = num;
                Integer n2 = num = Integer.valueOf(num - 1);
            }
            channel.basicNack(tag.longValue(), true, true);
            channel.txCommit();
        }
        catch (Exception e) {
            throw new ElephantException("\u83b7\u53d6MQ\u6d88\u606f\u5f02\u5e38\uff1a" + e.getMessage(), new Object[0]);
        }
        finally {
            try {
                if (null != channel) {
                    channel.close();
                }
                if (null != connection) {
                    connection.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    public void handleMessage(Integer indexId, String queueName, String exchange, String sourceQueueName, Object message, Map<String, Object> heareds, boolean isHandle) {
        Connection connection = null;
        Channel channel = null;
        try {
            ConnectionFactory connectionFactory = this.rabbitTemplate.getConnectionFactory();
            connection = connectionFactory.createConnection();
            channel = connection.createChannel(false);
            ArrayList tempList = Lists.newArrayList();
            tempList.add(1L);
            Long tag = 0L;
            for (int num = indexId.intValue(); num > 0; --num) {
                GetResponse response = channel.basicGet(queueName, false);
                if (tempList.size() == indexId.intValue()) {
                    channel.basicAck((long)indexId.intValue(), false);
                }
                tempList.add(response.getEnvelope().getDeliveryTag());
                tag = response.getEnvelope().getDeliveryTag();
            }
            channel.basicNack(tag.longValue(), true, true);
            if (isHandle) {
                this.send(exchange, sourceQueueName, message, heareds);
            }
        }
        catch (Exception e) {
            throw new ElephantException("\u624b\u52a8\u5904\u7406MQ\u6d88\u606f\u5f02\u5e38\uff1a" + e.getMessage(), new Object[0]);
        }
        finally {
            try {
                if (null != channel) {
                    channel.close();
                }
                if (null != connection) {
                    connection.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
        }
    }

    public Integer getMessageCount(Channel channel, String queueName) {
        Integer count = 0;
        Connection connection = null;
        try {
            if (null == channel) {
                ConnectionFactory connectionFactory = this.rabbitTemplate.getConnectionFactory();
                connection = connectionFactory.createConnection();
                channel = connection.createChannel(false);
            }
            AMQP.Queue.DeclareOk declareOk = channel.queueDeclarePassive(queueName);
            count = declareOk.getMessageCount();
        }
        catch (Exception e) {
            throw new ElephantException("\u83b7\u53d6MQ\u6d88\u606f\u603b\u6570\u5f02\u5e38\uff1a" + e.getMessage(), new Object[0]);
        }
        finally {
            try {
                if (null != channel) {
                    channel.close();
                }
                if (null != connection) {
                    connection.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
        }
        return count;
    }
}

