/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.check;

import com.xforceplus.elephant.basecommon.check.Check;
import com.xforceplus.elephant.basecommon.check.CheckChainConfig;
import com.xforceplus.elephant.basecommon.check.CheckContext;
import com.xforceplus.elephant.basecommon.check.CheckExecutor;
import com.xforceplus.elephant.basecommon.check.CheckParams;
import com.xforceplus.elephant.basecommon.check.chain.CheckChain;
import com.xforceplus.elephant.basecommon.check.chain.CheckNode;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.vaildate.Validator;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.StopWatch;

public class DefaultCheckExecutor
implements CheckExecutor,
Validator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ExpressionParser parser = new SpelExpressionParser();
    @Autowired
    private CheckChainConfig checkConfig;
    @Autowired
    private CheckContext checkContext;

    @Override
    public Map<String, Map<String, Object>> check(Long tenantId, String checkKey, CheckParams checkParams) {
        this.logger.debug("\u63a5\u6536\u5230\u68c0\u6d4b\u8bf7\u6c42,tenantId:{},checkKey:{},entity:{}", new Object[]{tenantId, checkKey, checkParams});
        this.checkEmpty(tenantId, "\u68c0\u6d4b\u5931\u8d25\uff1a\u79df\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty(checkKey, "\u68c0\u6d4b\u5931\u8d25\uff1a\u68c0\u6d4b\u94fe\u8def\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkNull(checkParams, "\u68c0\u6d4b\u5931\u8d25\uff1a\u68c0\u6d4b\u94fe\u8def\u4e0d\u80fd\u4e3aNull");
        HashMap<String, Map<String, Object>> update = new HashMap<String, Map<String, Object>>();
        checkParams.putCheck(update);
        CheckChain checkChain = this.checkConfig.getChain(tenantId, checkKey);
        String category = checkChain.getCategory();
        Map<String, Check> checkMaps = this.checkContext.getChecks(category);
        if (ValidatorUtil.isEmpty(checkMaps)) {
            String errorMessage = String.format("\u68c0\u6d4b\u5931\u8d25\uff1a\u4e0d\u652f\u6301\u7684\u68c0\u6d4b\u7c7b\u578b\u6216\u672a\u914d\u7f6e\u68c0\u6d4b\u914d\u7f6e\u3002category:%s", category);
            throw new ElephantException(errorMessage, new Object[0]);
        }
        StopWatch watch = new StopWatch("\u94fe\u8def\u68c0\u6d4b");
        ArrayList<String> paths = new ArrayList<String>();
        CheckNode node = checkChain.nextNode(checkParams);
        while (!CheckChain.END.equals(node)) {
            String code = node.getCode();
            if (paths.contains(code)) {
                throw new ElephantException(String.format("\u68c0\u6d4b\u94fe\u8def\u51fa\u73b0\u73af\u8def\uff0c\u91cd\u590d\u8fdb\u5165\u8282\u70b9\uff1a%s,\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", code), new Object[0]);
            }
            watch.start(code);
            String checkType = node.getCheckType();
            Check check = checkMaps.get(code);
            if (check == null) {
                String errorMessage = String.format("\u68c0\u6d4b\u5931\u8d25\uff1a\u672a\u627e\u5230tenantId:%s,category:%s,checkCode:%s\u7684\u68c0\u6d4b\u5b9e\u73b0\u3002", tenantId, category, code);
                throw new ElephantException(errorMessage, new Object[0]);
            }
            if (!update.containsKey(checkType)) {
                update.put(checkType, new HashMap());
            }
            Map typeUpdate = (Map)update.get(checkType);
            try {
                String checkResult = check.check(checkParams);
                typeUpdate.put(code, checkResult);
            }
            catch (Exception e) {
                this.logger.error("\u68c0\u6d4b\u5f02\u5e38", (Throwable)e);
                typeUpdate.put(code, "\u68c0\u6d4b\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5");
            }
            paths.add(code);
            node = checkChain.nextNode(checkParams);
            watch.stop();
        }
        this.logger.debug(watch.prettyPrint());
        this.logger.debug("\u6267\u884c\u94fe\u8def\uff1a{}", (Object)StringUtils.join(paths, (String)"==>"));
        return update;
    }
}

