/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.pubsub;

import com.xforceplus.apollo.client.netty.MCFactory;
import com.xforceplus.apollo.client.utils.SealedMessageBuilder;
import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.elephant.basecommon.enums.common.YesOrNoEnum;
import com.xforceplus.elephant.basecommon.pubsub.PubSubLogEntity;
import com.xforceplus.elephant.basecommon.rabbitmq.RabbitmqUtils;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PubSubUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired(required=false)
    private MCFactory mcFactory;
    @Autowired(required=false)
    private RabbitmqUtils rabbitmqUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSealedMessage(Long tenantId, String description, String requestName, Map<String, String> tags, String message) {
        if (ValidatorUtil.isEmpty(tenantId)) {
            return;
        }
        if (ValidatorUtil.isEmpty(requestName)) {
            return;
        }
        if (ValidatorUtil.isEmpty(tags)) {
            return;
        }
        if (ValidatorUtil.isEmpty(tags.get("payLoadId"))) {
            return;
        }
        if (ValidatorUtil.isEmpty(message)) {
            return;
        }
        PubSubLogEntity pubSubLogEntity = new PubSubLogEntity();
        pubSubLogEntity.setError("");
        pubSubLogEntity.setIsSuccessful(YesOrNoEnum.YES.getCode());
        pubSubLogEntity.setDescription(description);
        pubSubLogEntity.setSender("image");
        pubSubLogEntity.setReciver("pubsub");
        pubSubLogEntity.setTenantId(tenantId);
        pubSubLogEntity.setRequestName("image.syncBillTicket");
        pubSubLogEntity.setNumber(tags.get("payLoadId"));
        pubSubLogEntity.setCreateTime(new Date());
        try {
            SealedMessage sealedMessage = SealedMessageBuilder.buildSealedMessage((String)requestName, tags, (String)message);
            this.mcFactory.sendMessage(sealedMessage);
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u9001pubsub\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (null != this.rabbitmqUtils) {
                this.rabbitmqUtils.sendByDirectExchange("imagePubSubLogQueue", pubSubLogEntity);
            }
        }
    }
}

