/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.system.paas;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.LogApi;
import com.xforceplus.elephant.basecommon.enums.common.YesOrNoEnum;
import com.xforceplus.elephant.basecommon.enums.file.FileTranFormTypeEnum;
import com.xforceplus.elephant.basecommon.enums.log.ReceiverEnum;
import com.xforceplus.elephant.basecommon.enums.log.SenderEnum;
import com.xforceplus.elephant.basecommon.enums.log.SystemTypeEnum;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.log.MainHeader;
import com.xforceplus.elephant.basecommon.log.MyThreadLocal;
import com.xforceplus.elephant.basecommon.system.paas.PaasTokenUtils;
import com.xforceplus.elephant.basecommon.system.paas.SystemPaasSettings;
import com.xforceplus.elephant.basecommon.vaildate.Validator;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FileTranFormUtils
implements Validator {
    private Logger logger = LoggerFactory.getLogger(FileTranFormUtils.class);
    @Autowired
    private SystemPaasSettings systemPaasSettings;
    @Autowired
    private PaasTokenUtils paasTokenUtils;
    private final String OSS_REGEX = "^https?://(.+)\\.oss-cn-hangzhou\\.aliyuncs\\.com(.+)$";

    @LogApi(methodCode="covertFile", methodDescription="file\u8f6c\u56fe\u7247", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.MELETE)
    public String covertFile(Long tenantId, String tenantCode, String filePath, String fileSuffix, String title) {
        MainHeader mainHeader = MyThreadLocal.setObject(tenantId, filePath);
        this.checkEmpty(tenantId, "\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty(tenantCode, "\u79df\u6237code\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.checkEmpty(filePath, "\u6587\u4ef6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkEmpty(filePath, "\u8f6c\u6362\u6587\u4ef6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a!");
        String url = this.systemPaasSettings.getFileTranFormAsync().replace("{tenantId}", String.valueOf(tenantId));
        String token = this.paasTokenUtils.getLoginToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("x-app-token", token);
        JSONObject bodyJson = new JSONObject();
        bodyJson.put("file", (Object)filePath);
        bodyJson.put("title", (Object)title);
        bodyJson.put("group", (Object)tenantCode);
        bodyJson.put("scene", (Object)"0");
        bodyJson.put("fileSuffix", (Object)fileSuffix);
        bodyJson.put("callbackUrl", (Object)this.systemPaasSettings.getPdfCallbackUrl());
        bodyJson.put("customerNo", (Object)("fileTransform_" + System.getProperty("env")));
        Integer type = this.convertFileSuffixType(fileSuffix);
        if (ValidatorUtil.isEmpty(type)) {
            throw new ElephantException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b\u8f6c\u6362", new Object[0]);
        }
        bodyJson.put("type", (Object)type);
        this.logger.debug("covertFile bodyJson:{}", (Object)bodyJson.toJSONString());
        String responseStr = HttpUtils.doJsonPost(url, headers, bodyJson.toJSONString());
        if (StringUtils.isBlank((CharSequence)responseStr)) {
            mainHeader.fail("file\u6587\u4ef6\u8f6c\u56fe\u7247\u5f02\u5e38\uff0c\u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a", responseStr);
            throw new ElephantException("file\u6587\u4ef6\u8f6c\u56fe\u7247\u5f02\u5e38\uff0c\u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a\uff01", new Object[0]);
        }
        JSONObject jsonObject = JSONObject.parseObject((String)responseStr);
        int code = jsonObject.getIntValue("code");
        if (YesOrNoEnum.YES.getCode().equals(code)) {
            return jsonObject.getJSONObject("result").getString("taskId");
        }
        mainHeader.fail(jsonObject.getString("message"), responseStr);
        throw new ElephantException("file\u6587\u4ef6\u8f6c\u56fe\u7247\u5f02\u5e38:" + jsonObject.getString("message"), new Object[0]);
    }

    private Integer convertFileSuffixType(String fileSuffix) {
        if (fileSuffix.contains("doc")) {
            return FileTranFormTypeEnum.WORD_TO_JPG.getCode();
        }
        if (fileSuffix.contains("xls")) {
            return FileTranFormTypeEnum.EXCEL_TO_JPG.getCode();
        }
        if (fileSuffix.contains("ppt")) {
            return FileTranFormTypeEnum.PPT_TO_JPG.getCode();
        }
        return null;
    }
}

