/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.vaildate;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorUtil {
    private static final Logger logger = LoggerFactory.getLogger(ValidatorUtil.class);

    public static boolean isEmpty(String value) {
        return StringUtils.isEmpty((CharSequence)value) || "-".equals(value);
    }

    public static boolean isNotEmpty(String value) {
        return !ValidatorUtil.isEmpty(value);
    }

    public static boolean isEmpty(Collection<?> value) {
        return value == null || value.isEmpty() || value.stream().allMatch(v -> ValidatorUtil.isEmpty(v));
    }

    public static boolean isNotEmpty(Collection<?> value) {
        return !ValidatorUtil.isEmpty(value);
    }

    public static boolean isEmpty(Map value) {
        return value == null || value.isEmpty();
    }

    public static boolean isNotEmpty(Map value) {
        return !ValidatorUtil.isEmpty(value);
    }

    public static boolean isEmpty(Object value) {
        if (value instanceof String) {
            return ValidatorUtil.isEmpty((String)value);
        }
        if (value instanceof Map) {
            return ValidatorUtil.isEmpty((Map)value);
        }
        if (value instanceof Collection) {
            return ValidatorUtil.isEmpty((Collection)value);
        }
        return value == null;
    }

    public static boolean isNotEmpty(Object value) {
        return !ValidatorUtil.isEmpty(value);
    }

    public static boolean inLength(String value, int ... lengths) {
        return Arrays.stream(lengths).anyMatch(length -> value.length() == length);
    }

    public static boolean inLengthRange(String value, int minLength, int maxLength) {
        int length = value.length();
        return length >= minLength && length <= maxLength;
    }

    public static boolean inRange(Integer value, int minValue, int maxValue, String type) {
        switch (type) {
            case "()": {
                return value > minValue && value < maxValue;
            }
            case "(]": {
                return value > minValue && value <= maxValue;
            }
            case "[)": {
                return value >= minValue && value < maxValue;
            }
        }
        return value >= minValue && value <= maxValue;
    }

    public static boolean isInteger(String value) {
        String regex = "0|([1-9][0-9]{0,10})";
        return Pattern.matches(regex, value);
    }

    public static boolean isNumber(String value) {
        String regex = "[0-9]+";
        return Pattern.matches(regex, value);
    }

    public static boolean isAmount(String value) {
        String regex = "^-?\\d{1,18}(\\.\\d{0,6})?$";
        return Pattern.matches(regex, value);
    }

    public static boolean noSymbols(String value) {
        String regex = "[0-9a-zA-Z]+";
        return Pattern.matches(regex, value);
    }

    public static boolean noSymbolsAndLower(String value) {
        String regex = "[0-9A-Z]+";
        return Pattern.matches(regex, value);
    }

    public static boolean isDate(String value, String pattern) {
        try {
            if (ValidatorUtil.isEmpty(value) || ValidatorUtil.isEmpty(pattern) || value.length() != pattern.length()) {
                return false;
            }
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            format.setLenient(false);
            format.parse(value);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isTimestamp(String value, String pattern) {
        try {
            if (!ValidatorUtil.isDate(value, pattern)) {
                return false;
            }
            Date date = new SimpleDateFormat(pattern).parse(value);
            if (date.getTime() >= 14400000L && date.getTime() <= 2147483647000L) {
                return true;
            }
        }
        catch (ParseException e) {
            return false;
        }
        return false;
    }

    public static boolean isTrue(Boolean flag) {
        return flag != null && flag != false;
    }

    public static boolean isTrue(String value) {
        return Boolean.valueOf(value);
    }

    public static boolean isFalse(Boolean flag) {
        return !ValidatorUtil.isTrue(flag);
    }

    public static boolean isFalse(String value) {
        return !ValidatorUtil.isTrue(value);
    }

    public static boolean allFieldEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        return Arrays.stream(obj.getClass().getDeclaredFields()).allMatch(field -> {
            field.setAccessible(true);
            try {
                return ValidatorUtil.isEmpty(field.get(obj));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return false;
            }
        });
    }
}

