/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.help;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.params.SetParams;

@Component
public class RedisUtils {
    private final Logger logger = LoggerFactory.getLogger(RedisUtils.class);
    private static final Long RELEASE_SUCCESS = 1L;
    private static final String LOCK_SUCCESS = "OK";
    private static final String SET_IF_NOT_EXIST = "NX";
    private static final String SET_WITH_EXPIRE_TIME = "PX";
    public static final String UNLOCK_LUA;
    @Autowired
    protected RedisTemplate redisTemplate;

    public String getDistributedLockValue(String lockKey) {
        try {
            RedisCallback callback = connection -> {
                Object nativeConnection = connection.getNativeConnection();
                if (nativeConnection instanceof JedisCluster) {
                    this.logger.debug("redis\u96c6\u7fa4\u6a21\u5f0f\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u503c\uff0clockKey[{}]", (Object)lockKey);
                    return ((JedisCluster)nativeConnection).get(lockKey);
                }
                if (nativeConnection instanceof Jedis) {
                    this.logger.debug("redis\u5355\u673a\u6a21\u5f0f\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u503c\uff0clockKey[{}]", (Object)lockKey);
                    return ((Jedis)nativeConnection).get(lockKey);
                }
                return null;
            };
            return (String)this.redisTemplate.execute(callback);
        }
        catch (Exception e) {
            this.logger.error("get redis distributed value occur an exception", (Throwable)e);
            return null;
        }
    }

    public Long getDistributedLockExpire(String lockKey) {
        try {
            RedisCallback callback = connection -> {
                Object nativeConnection = connection.getNativeConnection();
                if (nativeConnection instanceof JedisCluster) {
                    this.logger.debug("redis\u96c6\u7fa4\u6a21\u5f0f\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u6709\u6548\u671f\uff0clockKey[{}]", (Object)lockKey);
                    return ((JedisCluster)nativeConnection).ttl(lockKey);
                }
                if (nativeConnection instanceof Jedis) {
                    this.logger.debug("redis\u5355\u673a\u6a21\u5f0f\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u6709\u6548\u671f\uff0clockKey[{}]", (Object)lockKey);
                    return ((Jedis)nativeConnection).ttl(lockKey);
                }
                return null;
            };
            return (Long)this.redisTemplate.execute(callback);
        }
        catch (Exception e) {
            this.logger.error("get redis distributed expire occur an exception", (Throwable)e);
            return null;
        }
    }

    public boolean tryGetDistributedLock(String lockKey, String lockValue, int expireTime) {
        boolean hasGet = false;
        try {
            RedisCallback callback = connection -> {
                Object nativeConnection = connection.getNativeConnection();
                SetParams setParams = new SetParams();
                setParams.nx();
                setParams.px((long)expireTime);
                if (nativeConnection instanceof JedisCluster) {
                    this.logger.debug("redis\u96c6\u7fa4\u6a21\u5f0f\u8bbe\u7f6e\u5206\u5e03\u5f0f\u9501\uff0clockKey[{}],lockValue[{}]", (Object)lockKey, (Object)lockValue);
                    return ((JedisCluster)nativeConnection).set(lockKey, lockValue, setParams);
                }
                if (nativeConnection instanceof Jedis) {
                    this.logger.debug("redis\u5355\u673a\u6a21\u5f0f\u8bbe\u7f6e\u5206\u5e03\u5f0f\u9501\uff0clockKey[{}],lockValue[{}]", (Object)lockKey, (Object)lockValue);
                    return ((Jedis)nativeConnection).set(lockKey, lockValue, setParams);
                }
                return null;
            };
            String status = (String)this.redisTemplate.execute(callback);
            if (LOCK_SUCCESS.equals(status)) {
                hasGet = true;
            }
        }
        catch (Exception e) {
            this.logger.error("redis tryGetDistributedLock exception {}:{}", new Object[]{lockKey, lockValue, e});
        }
        return hasGet;
    }

    public boolean tryGetDistributedLockException(String lockKey, String lockValue, int expireTime) {
        boolean hasGet = false;
        RedisCallback callback = connection -> {
            Object nativeConnection = connection.getNativeConnection();
            SetParams setParams = new SetParams();
            setParams.nx();
            setParams.px((long)expireTime);
            if (nativeConnection instanceof JedisCluster) {
                this.logger.debug("redis\u96c6\u7fa4\u6a21\u5f0f\u8bbe\u7f6e\u5206\u5e03\u5f0f\u9501\uff0clockKey[{}],lockValue[{}]", (Object)lockKey, (Object)lockValue);
                return ((JedisCluster)nativeConnection).set(lockKey, lockValue, setParams);
            }
            if (nativeConnection instanceof Jedis) {
                this.logger.debug("redis\u5355\u673a\u6a21\u5f0f\u8bbe\u7f6e\u5206\u5e03\u5f0f\u9501\uff0clockKey[{}],lockValue[{}]", (Object)lockKey, (Object)lockValue);
                return ((Jedis)nativeConnection).set(lockKey, lockValue, setParams);
            }
            return null;
        };
        String status = (String)this.redisTemplate.execute(callback);
        if (LOCK_SUCCESS.equals(status)) {
            hasGet = true;
        }
        return hasGet;
    }

    public boolean tryGetDistributedLock(String lockKey, String lockValue, int expireTime, int maxRetryTimes, long retryIntervalTimeMillis) {
        boolean hasGet = false;
        try {
            RedisCallback callback = connection -> {
                Object nativeConnection = connection.getNativeConnection();
                SetParams setParams = new SetParams();
                setParams.nx();
                setParams.px((long)expireTime);
                if (nativeConnection instanceof JedisCluster) {
                    this.logger.debug("redis\u96c6\u7fa4\u6a21\u5f0f\u8bbe\u7f6e\u5206\u5e03\u5f0f\u9501\uff0clockKey[{}],lockValue[{}]", (Object)lockKey, (Object)lockValue);
                    return ((JedisCluster)nativeConnection).set(lockKey, lockValue, setParams);
                }
                if (nativeConnection instanceof Jedis) {
                    this.logger.debug("redis\u5355\u673a\u6a21\u5f0f\u8bbe\u7f6e\u5206\u5e03\u5f0f\u9501\uff0clockKey[{}],lockValue[{}]", (Object)lockKey, (Object)lockValue);
                    return ((Jedis)nativeConnection).set(lockKey, lockValue, setParams);
                }
                return null;
            };
            String status = null;
            for (int i = 0; i < maxRetryTimes; ++i) {
                status = (String)this.redisTemplate.execute(callback);
                if (LOCK_SUCCESS.equals(status)) {
                    hasGet = true;
                } else {
                    if (retryIntervalTimeMillis > 0L) {
                        Thread.sleep(retryIntervalTimeMillis);
                    }
                    if (!Thread.currentThread().isInterrupted()) {
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            this.logger.error("redis tryGetDistributedLock exception {}:{}", new Object[]{lockKey, lockValue, e});
        }
        return hasGet;
    }

    public boolean releaseDistributedLock(String lockKey, String lockValue) {
        boolean hasRelease = false;
        try {
            RedisCallback callback = connection -> {
                Object nativeConnection = connection.getNativeConnection();
                if (nativeConnection instanceof JedisCluster) {
                    this.logger.debug("redis\u96c6\u7fa4\u6a21\u5f0f\u91ca\u653e\u5206\u5e03\u5f0f\u9501\uff0clockKey[{}],lockValue[{}]", (Object)lockKey, (Object)lockValue);
                    return (Long)((JedisCluster)nativeConnection).eval(UNLOCK_LUA, Collections.singletonList(lockKey), Collections.singletonList(lockValue));
                }
                if (nativeConnection instanceof Jedis) {
                    this.logger.debug("redis\u5355\u673a\u6a21\u5f0f\u91ca\u653e\u5206\u5e03\u5f0f\u9501\uff0clockKey[{}],lockValue[{}]", (Object)lockKey, (Object)lockValue);
                    return (Long)((Jedis)nativeConnection).eval(UNLOCK_LUA, Collections.singletonList(lockKey), Collections.singletonList(lockValue));
                }
                return 0L;
            };
            Long result = (Long)this.redisTemplate.execute(callback);
            if (RELEASE_SUCCESS.equals(result)) {
                hasRelease = true;
            }
        }
        catch (Exception e) {
            this.logger.error("redis tryGetDistributedLock{}:{}:{}", new Object[]{lockKey, lockValue, e});
        }
        return hasRelease;
    }

    public boolean hasKey(String key) {
        try {
            return this.redisTemplate.hasKey((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void del(String ... key) {
        if (key != null && key.length > 0) {
            if (key.length == 1) {
                this.redisTemplate.delete((Object)key[0]);
            } else {
                this.redisTemplate.delete((Collection)CollectionUtils.arrayToList((Object)key));
            }
        }
    }

    public Object get(String key) {
        return key == null ? null : this.redisTemplate.opsForValue().get((Object)key);
    }

    public boolean set(String key, Object value) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean set(String key, Object value, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static {
        StringBuilder unlockSb = new StringBuilder();
        unlockSb.append("if redis.call(\"get\",KEYS[1]) == ARGV[1] ");
        unlockSb.append("then ");
        unlockSb.append("    return redis.call(\"del\",KEYS[1]) ");
        unlockSb.append("else ");
        unlockSb.append("    return 0 ");
        unlockSb.append("end ");
        UNLOCK_LUA = unlockSb.toString();
    }
}

