/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.system.paas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.xforceplus.elephant.basecommon.annotation.LogApi;
import com.xforceplus.elephant.basecommon.enums.log.ReceiverEnum;
import com.xforceplus.elephant.basecommon.enums.log.SenderEnum;
import com.xforceplus.elephant.basecommon.enums.log.SystemTypeEnum;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.log.MyThreadLocal;
import com.xforceplus.elephant.basecommon.system.entity.VerifyEntity;
import com.xforceplus.elephant.basecommon.system.paas.OrgUtils;
import com.xforceplus.elephant.basecommon.system.paas.PaasTokenUtils;
import com.xforceplus.elephant.basecommon.system.paas.SystemPaasSettings;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
public class VerifyUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SystemPaasSettings systemPaasSettings;
    @Autowired
    private PaasTokenUtils paasTokenUtils;
    @Autowired
    private OrgUtils orgUtils;

    @LogApi(methodCode="sendVerifyRequest", methodDescription="\u53d1\u8d77\u9a8c\u771f", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PHOENIX)
    public String sendVerifyRequest(Long tenantId, VerifyEntity verifyEntity) {
        try {
            MyThreadLocal.setObject(tenantId, verifyEntity.getInvoiceNo(), verifyEntity.getInvoiceNo(), verifyEntity.getInvoiceCode());
            String url = this.systemPaasSettings.getVerifyRequestUrl().replace("{tenant-id}", String.valueOf(tenantId));
            String token = this.paasTokenUtils.getLoginToken();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            headers.put("x-app-token", token);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("invoiceCode", verifyEntity.getInvoiceCode());
            params.put("invoiceNo", verifyEntity.getInvoiceNo());
            params.put("paperDrewDate", verifyEntity.getPaperDrewDate());
            params.put("amount", verifyEntity.getAmountWithoutTax());
            params.put("checkCode", verifyEntity.getCheckCode());
            params.put("tenantCode", String.valueOf(tenantId));
            this.logger.debug("\u53d1\u8d77\u9a8c\u771f\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, url, JSON.toJSONString(params)});
            String responseStr = HttpUtils.doJsonPost(url, headers, JSON.toJSONString(params));
            this.logger.debug("\u53d1\u8d77\u9a8c\u771f\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u8d77\u9a8c\u771f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u53d1\u8d77\u9a8c\u771f\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="getVerifyResult", methodDescription="\u83b7\u53d6\u9a8c\u771f\u7ed3\u679c", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PHOENIX)
    public String getVerifyResult(Long tenantId, String taskId) {
        try {
            MyThreadLocal.setObject(tenantId, taskId);
            String url = this.systemPaasSettings.getVerfiyResultUrl().replace("{tenant-id}", String.valueOf(tenantId)).replace("{task-id}", taskId);
            String token = this.paasTokenUtils.getLoginToken();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            headers.put("x-app-token", token);
            this.logger.debug("\u83b7\u53d6\u9a8c\u771f\u7ed3\u679c\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)tenantId, (Object)url);
            String responseStr = HttpUtils.doGet(url, headers, null);
            this.logger.debug("\u83b7\u53d6\u9a8c\u771f\u7ed3\u679c\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u9a8c\u771f\u7ed3\u679c\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u83b7\u53d6\u9a8c\u771f\u7ed3\u679c\u5931\u8d25", e);
        }
    }

    @LogApi(methodCode="getSysOrgIds", methodDescription="\u83b7\u53d6\u7ec4\u7ec7ID\u96c6\u5408", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PHOENIX)
    @Cacheable(cacheNames={"sysOrgIds"}, key="#root.args[0]", unless="#result == null || #result.size() == 0")
    public List<Long> getSysOrgIds(Long tenantId) {
        try {
            MyThreadLocal.setObject(tenantId, StringHelp.safeToString(tenantId));
            HashMap<String, String> orgParams = new HashMap<String, String>();
            orgParams.put("tenantId", StringHelp.safeToString(tenantId));
            orgParams.put("rootOrg", "true");
            JSONArray orgs = this.orgUtils.getOrgs(tenantId, orgParams);
            ArrayList<Long> sysOrgIds = new ArrayList<Long>(orgs.size());
            for (int i = 0; i < orgs.size(); ++i) {
                JSONObject org = orgs.getJSONObject(i);
                sysOrgIds.add(org.getLongValue("orgId"));
            }
            return sysOrgIds;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7ec4\u7ec7ID\u96c6\u5408\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u83b7\u53d6\u7ec4\u7ec7ID\u96c6\u5408\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="checkBlacklist", methodDescription="\u9ed1\u540d\u5355\u68c0\u6d4b", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PHOENIX)
    public List<String> checkBlacklist(Long tenantId, String ... taxNos) {
        try {
            MyThreadLocal.setObject(tenantId, taxNos.toString());
            String url = this.systemPaasSettings.getCheckBlacklistUrl().replace("{tenant-id}", String.valueOf(tenantId));
            String token = this.paasTokenUtils.getLoginToken();
            List<Long> sysOrgIds = this.getSysOrgIds(tenantId);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            headers.put("x-app-token", token);
            JSONObject params = new JSONObject();
            params.put("keyWords", (Object)taxNos);
            params.put("sysOrgIds", sysOrgIds);
            params.put("tenantId", (Object)tenantId);
            this.logger.debug("\u53d1\u8d77\u9ed1\u540d\u5355\u68c0\u6d4b\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, url, JSON.toJSONString((Object)params)});
            String responseStr = HttpUtils.doJsonPost(url, headers, params.toJSONString());
            this.logger.debug("\u53d1\u8d77\u9ed1\u540d\u5355\u68c0\u6d4b\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            JSONObject resultObject = JSONObject.parseObject((String)responseStr);
            if (ValidatorUtil.isEmpty((Map)resultObject)) {
                this.logger.warn("\u53d1\u8d77\u9ed1\u540d\u5355\u68c0\u6d4b\u5f02\u5e38");
                throw new ElephantException("\u53d1\u8d77\u9ed1\u540d\u5355\u68c0\u6d4b\u5f02\u5e38");
            }
            String respCode = resultObject.getString("code");
            String respMsg = resultObject.getString("message");
            if (!"1".equals(respCode)) {
                throw new ElephantException(respMsg);
            }
            return (List)resultObject.getObject("result", (TypeReference)new TypeReference<List<String>>(){});
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u8d77\u9ed1\u540d\u5355\u68c0\u6d4b\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u53d1\u8d77\u9ed1\u540d\u5355\u68c0\u6d4b\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="checkSensitiveWord", methodDescription="\u654f\u611f\u8bcd\u68c0\u6d4b", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PHOENIX)
    public List<JSONObject> checkSensitiveWord(Long tenantId, String content) {
        try {
            MyThreadLocal.setObject(tenantId, "");
            String url = this.systemPaasSettings.getCheckSensitiveWordsUrl().replace("{tenant-id}", String.valueOf(tenantId));
            String token = this.paasTokenUtils.getLoginToken();
            List<Long> sysOrgIds = this.getSysOrgIds(tenantId);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            headers.put("x-app-token", token);
            JSONObject params = new JSONObject();
            params.put("keyword", (Object)content);
            params.put("sysOrgIds", sysOrgIds);
            params.put("tenantId", (Object)tenantId);
            this.logger.debug("\u53d1\u8d77\u654f\u611f\u8bcd\u68c0\u6d4b\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, url, JSON.toJSONString((Object)params)});
            String responseStr = HttpUtils.doJsonPost(url, headers, params.toJSONString());
            this.logger.debug("\u53d1\u8d77\u654f\u611f\u8bcd\u68c0\u6d4b\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            JSONObject resultObject = JSONObject.parseObject((String)responseStr);
            if (ValidatorUtil.isEmpty((Map)resultObject)) {
                this.logger.warn("\u53d1\u8d77\u654f\u611f\u8bcd\u68c0\u6d4b\u5f02\u5e38");
                throw new ElephantException("\u53d1\u8d77\u654f\u611f\u8bcd\u68c0\u6d4b\u5f02\u5e38");
            }
            String respCode = resultObject.getString("code");
            String respMsg = resultObject.getString("message");
            if (!"1".equals(respCode)) {
                throw new ElephantException(respMsg);
            }
            return (List)resultObject.getObject("result", (TypeReference)new TypeReference<List<JSONObject>>(){});
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u8d77\u654f\u611f\u8bcd\u68c0\u6d4b\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u53d1\u8d77\u654f\u611f\u8bcd\u68c0\u6d4b\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="checkLegalPerson", methodDescription="\u6cd5\u4eba\u4e3b\u6570\u636e\u68c0\u6d4b", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PHOENIX)
    public boolean checkLegalPerson(Long tenantId, String taxNum, String companyName) {
        try {
            JSONArray orgs;
            MyThreadLocal.setObject(tenantId, taxNum);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("tenantId", String.valueOf(tenantId));
            if (ValidatorUtil.isNotEmpty(taxNum)) {
                params.put("taxNum", taxNum);
            }
            if (ValidatorUtil.isNotEmpty(companyName)) {
                params.put("companyName", companyName);
            }
            return ValidatorUtil.isNotEmpty(orgs = this.orgUtils.getOrgs(tenantId, params));
        }
        catch (Exception e) {
            this.logger.error("\u6cd5\u4eba\u4e3b\u6570\u636e\u68c0\u6d4b\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u6cd5\u4eba\u4e3b\u6570\u636e\u68c0\u6d4b\u5f02\u5e38", e);
        }
    }

    private String checkCompanyName(Long tenantId, String taxNum, String taxNumName) {
        try {
            MyThreadLocal.setObject(tenantId, taxNum);
            if (ValidatorUtil.isEmpty(taxNum) || ValidatorUtil.isEmpty(taxNumName)) {
                return "\u6cd5\u4eba\u4e3b\u6570\u636e\u68c0\u6d4b\u5f02\u5e38[\u7a0e\u53f7\u6216\u540d\u79f0\u4e3a\u7a7a];";
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("tenantId", String.valueOf(tenantId));
            params.put("taxNum", taxNum);
            JSONArray orgs = this.orgUtils.getOrgs(tenantId, params);
            if (ValidatorUtil.isEmpty(orgs)) {
                return "\u6cd5\u4eba\u4e3b\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\uff01;";
            }
            String message = this.compareToCompanyName(orgs.getJSONObject(0), taxNumName);
            if (ValidatorUtil.isEmpty(message)) {
                return "";
            }
            return message;
        }
        catch (Exception e) {
            this.logger.error("\u6cd5\u4eba\u4e3b\u6570\u636e\u68c0\u6d4b\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u6cd5\u4eba\u4e3b\u6570\u636e\u68c0\u6d4b\u5f02\u5e38;", e);
        }
    }

    private String compareToCompanyName(JSONObject jsonObject, String sourceName) {
        String companyName = jsonObject.getString("companyName");
        if (!(companyName = companyName.replaceAll("\uff08", "(").replaceAll("\uff09", ")")).equalsIgnoreCase(sourceName.replaceAll("\uff08", "(").replaceAll("\uff09", ")"))) {
            return "\u8d2d\u65b9\u540d\u79f0\u4e0e\u7ef4\u62a4\u7684\u8d2d\u65b9\u4fe1\u606f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5b9e\uff01;";
        }
        return "";
    }
}

