/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.help;

import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.help.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StreamUtils;

public class ZipUtils {
    private static Logger logger = LoggerFactory.getLogger(ZipUtils.class);

    private ZipUtils() {
    }

    public static File zip(String filePath) {
        File target = null;
        File source = new File(filePath);
        if (source.exists()) {
            String zipName = source.getName() + ".zip";
            target = new File(source.getParent(), zipName);
            if (target.exists()) {
                target.delete();
            }
            FileOutputStream fos = null;
            ZipOutputStream zos = null;
            try {
                fos = new FileOutputStream(target);
                zos = new ZipOutputStream(new BufferedOutputStream(fos));
                ZipUtils.addEntry("", source, zos);
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(zos, fos);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(zos, fos);
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void addEntry(String base, File source, ZipOutputStream zos) throws IOException {
        String entry = base + source.getName();
        if (source.isDirectory()) {
            File[] fileArray = source.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                ZipUtils.addEntry(entry + "/", file, zos);
                ++n2;
            }
            return;
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            byte[] buffer = new byte[10240];
            fis = new FileInputStream(source);
            bis = new BufferedInputStream(fis, buffer.length);
            int read = 0;
            zos.putNextEntry(new ZipEntry(entry));
            while ((read = bis.read(buffer, 0, buffer.length)) != -1) {
                zos.write(buffer, 0, read);
            }
            zos.closeEntry();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bis, fis);
            throw throwable;
        }
        IOUtils.closeQuietly(bis, fis);
    }

    public static void unzip(String filePath) {
        File source = new File(filePath);
        if (source.exists()) {
            ZipInputStream zis = null;
            BufferedOutputStream bos = null;
            try {
                zis = new ZipInputStream(new FileInputStream(source));
                ZipEntry entry = null;
                while ((entry = zis.getNextEntry()) != null && !entry.isDirectory()) {
                    File target = new File(source.getParent(), entry.getName());
                    if (!target.getParentFile().exists()) {
                        target.getParentFile().mkdirs();
                    }
                    bos = new BufferedOutputStream(new FileOutputStream(target));
                    int read = 0;
                    byte[] buffer = new byte[10240];
                    while ((read = zis.read(buffer, 0, buffer.length)) != -1) {
                        bos.write(buffer, 0, read);
                    }
                    bos.flush();
                }
                zis.closeEntry();
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(zis, bos);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(zis, bos);
        }
    }

    public static void downloadImage(String remoteUrl, String localPath) {
        try (InputStream is = HttpUtils.doGetInputStream(remoteUrl);){
            byte[] bytes = StreamUtils.copyToByteArray((InputStream)is);
            File parentFile = new File(localPath.substring(0, localPath.lastIndexOf("/")));
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            FileCopyUtils.copy((byte[])bytes, (File)new File(localPath));
        }
        catch (IOException e) {
            logger.error("\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
        }
    }
}

