/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.system.paas;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.api.client.util.Lists;
import com.xforceplus.elephant.basecommon.annotation.LogApi;
import com.xforceplus.elephant.basecommon.enums.common.YesOrNoEnum;
import com.xforceplus.elephant.basecommon.enums.log.ReceiverEnum;
import com.xforceplus.elephant.basecommon.enums.log.SenderEnum;
import com.xforceplus.elephant.basecommon.enums.log.SystemTypeEnum;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.log.MainHeader;
import com.xforceplus.elephant.basecommon.log.MyThreadLocal;
import com.xforceplus.elephant.basecommon.system.paas.PaasTokenUtils;
import com.xforceplus.elephant.basecommon.system.paas.SystemPaasSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OfdImageUtils {
    private Logger logger = LoggerFactory.getLogger(PaasTokenUtils.class);
    @Autowired
    private SystemPaasSettings systemPaasSettings;
    @Autowired
    private PaasTokenUtils paasTokenUtils;

    @LogApi(methodCode="ofdTranForm", methodDescription="ofd\u8f6c\u56fe\u7247", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.MELETE)
    public List<String> ofdTranForm(Long tenantId, String filePath) {
        ArrayList imageUrlList = Lists.newArrayList();
        MainHeader mainHeader = MyThreadLocal.setObject(tenantId, filePath);
        String url = this.systemPaasSettings.getOfdTranForm().replace("{tenantId}", String.valueOf(tenantId));
        String token = this.paasTokenUtils.getLoginToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("x-app-token", token);
        JSONObject bodyJson = new JSONObject();
        bodyJson.put("title", (Object)"tenantId");
        bodyJson.put("group", (Object)String.valueOf(tenantId));
        bodyJson.put("file", (Object)filePath);
        bodyJson.put("fileSuffix", (Object)".ofd");
        mainHeader.setMethodUrl(url);
        String responseStr = HttpUtils.doJsonPost(url, headers, bodyJson.toJSONString());
        if (StringUtils.isBlank((CharSequence)responseStr)) {
            mainHeader.fail("OFD\u6587\u4ef6\u8f6c\u56fe\u7247\u5f02\u5e38\uff0c\u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a", responseStr);
            return Lists.newArrayList();
        }
        JSONObject jsonObject = JSONObject.parseObject((String)responseStr);
        int code = jsonObject.getIntValue("code");
        if (YesOrNoEnum.YES.getCode().equals(code)) {
            if (jsonObject.get((Object)"result") instanceof String) {
                imageUrlList.add(jsonObject.getString("result"));
                return imageUrlList;
            }
            if (jsonObject.get((Object)"result") instanceof JSONArray) {
                return jsonObject.getJSONArray("result").toJavaList(String.class);
            }
        }
        mainHeader.fail(jsonObject.getString("message"), responseStr);
        return imageUrlList;
    }
}

