/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.system.paas;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.LogApi;
import com.xforceplus.elephant.basecommon.enums.common.YesOrNoEnum;
import com.xforceplus.elephant.basecommon.enums.log.ReceiverEnum;
import com.xforceplus.elephant.basecommon.enums.log.SenderEnum;
import com.xforceplus.elephant.basecommon.enums.log.SystemTypeEnum;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.log.MainHeader;
import com.xforceplus.elephant.basecommon.log.MyThreadLocal;
import com.xforceplus.elephant.basecommon.system.paas.PaasTokenUtils;
import com.xforceplus.elephant.basecommon.system.paas.SystemPaasSettings;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PdfImageUtils {
    private Logger logger = LoggerFactory.getLogger(PaasTokenUtils.class);
    @Autowired
    private SystemPaasSettings systemPaasSettings;
    @Autowired
    private PaasTokenUtils paasTokenUtils;
    public static final String PDF_SCENE_UNDEFINED = "0";
    public static final String PDF_SCENE_NAKED_SCAN = "1";
    public static final String PDF_SCENE_A4_TICKET = "2";
    public static final String PDF_SCENE_PHOTO = "3";
    public static final String PDF_SCENE_UPLOAD = "4";

    @LogApi(methodCode="pdfTranForm", methodDescription="pdf\u8f6c\u56fe\u7247", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.MELETE)
    public String pdfTranForm(Long tenantId, String tenantCode, String filePath, String title, String scene) {
        if (ValidatorUtil.isEmpty(tenantId)) {
            return "";
        }
        MainHeader mainHeader = MyThreadLocal.setObject(tenantId, filePath);
        String url = this.systemPaasSettings.getPdfTranForm().replace("{tenantId}", String.valueOf(tenantId));
        String token = this.paasTokenUtils.getLoginToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("x-app-token", token);
        JSONObject bodyJson = new JSONObject();
        bodyJson.put("file", (Object)filePath);
        bodyJson.put("title", (Object)title);
        bodyJson.put("group", (Object)tenantCode);
        bodyJson.put("scene", (Object)scene);
        bodyJson.put("fileSuffix", (Object)".pdf");
        bodyJson.put("callbackUrl", (Object)this.systemPaasSettings.getPdfCallbackUrl());
        bodyJson.put("customerNo", (Object)String.valueOf(tenantId));
        this.logger.debug("pdfTranForm bodyJson:{}", (Object)bodyJson.toJSONString());
        String responseStr = HttpUtils.doJsonPost(url, headers, bodyJson.toJSONString());
        if (StringUtils.isBlank((CharSequence)responseStr)) {
            mainHeader.fail("PDF\u6587\u4ef6\u8f6c\u56fe\u7247\u5f02\u5e38\uff0c\u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a", responseStr);
            return "";
        }
        JSONObject jsonObject = JSONObject.parseObject((String)responseStr);
        int code = jsonObject.getIntValue("code");
        if (YesOrNoEnum.YES.getCode().equals(code)) {
            return jsonObject.getJSONObject("result").getString("taskId");
        }
        mainHeader.fail(jsonObject.getString("message"), responseStr);
        return "";
    }
}

