package com.xforceplus.elephant.image;

import com.baomidou.mybatisplus.autoconfigure.MybatisPlusAutoConfiguration;
import com.ctrip.framework.apollo.spring.annotation.EnableApolloConfig;
import com.xforceplus.elephant.image.controller.errorcode.LocalErrorCodeRepository;
import com.xforceplus.general.message.EnableMessage;
import com.xforceplus.general.starter.errorcode.EnableTenantErrorCoder;
import org.mybatis.spring.annotation.MapperScan;
import org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.autoconfigure.jdbc.DataSourceHealthContributorAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.mail.MailHealthContributorAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.jdbc.DataSourcePoolMetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

@EnableMessage
@EnableScheduling
@EnableAsync
@EnableApolloConfig
@EnableTenantErrorCoder(repository = LocalErrorCodeRepository.class)
@SpringBootApplication(scanBasePackages = {"com.xforceplus.elephant", "com.xforceplus.feign", "com.xforceplus.phoenix", "com.xforceplus.tenant.data.auth", "com.xforceplus.tower",
    "com.xforceplus.general"}, exclude = {
    DataSourceAutoConfiguration.class,
    DataSourceHealthContributorAutoConfiguration.class,
    DataSourcePoolMetricsAutoConfiguration.class,
    MybatisPlusAutoConfiguration.class,
    MybatisAutoConfiguration.class,
    MailHealthContributorAutoConfiguration.class
})
@MapperScan({"com.xforceplus.elephant.image.core.repository"})
public class ImageServiceSaasApplication {

    public static void main(final String[] args) {
        SpringApplication.run(ImageServiceSaasApplication.class, args);
    }

}
