package com.xforceplus.elephant.image.config;

import com.alibaba.mq.amqp.utils.UserUtils;
import com.xforceplus.elephant.image.listener.MqQueueSizeListener;
import java.math.BigDecimal;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.listener.RabbitListenerContainerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AliRabbitConnectionFactoryConfiguration {

    private Logger logger = LoggerFactory.getLogger(getClass());

    @Value("${image.ali.rabbit.access-secret:}")
    private String accessKeySeret;
    @Value("${image.ali.rabbit.access-key:}")
    private String accessKeyId;
    @Value("${image.ali.rabbit.owner-id:}")
    private String resourceOwnerId;

    @Bean
    @ConditionalOnProperty(name = "image.ali.rabbit.enabled", havingValue = "true")
    public RabbitListenerContainerFactory<?> rabbitListenerContainerFactoryProd(CachingConnectionFactory connectionFactory) {
        logger.info("开始加载ali rabbitmq");
        final BigDecimal decimal = new BigDecimal(resourceOwnerId);
        final String userName = UserUtils.getUserName(accessKeyId, decimal.longValue());
        connectionFactory.setUsername(userName);
        connectionFactory.setPassword(getPassword());
        // 开启Connection自动恢复。
        connectionFactory.getRabbitConnectionFactory().setAutomaticRecoveryEnabled(true);
        // 设置Connection重试时间间隔为10秒。
        connectionFactory.getRabbitConnectionFactory().setNetworkRecoveryInterval(10000);
        // 开启Topology自动恢复。
        connectionFactory.getRabbitConnectionFactory().setTopologyRecoveryEnabled(true);
        final SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        return factory;
    }

    @Bean
    @ConditionalOnBean(RabbitListenerContainerFactory.class)
    public MqQueueSizeListener aliMqQueueSizeListener(CachingConnectionFactory connectionFactory) {
        return new MqQueueSizeListener(connectionFactory);
    }

    @Bean
    @ConditionalOnMissingBean(RabbitListenerContainerFactory.class)
    public MqQueueSizeListener mqQueueSizeListener(CachingConnectionFactory connectionFactory) {
        return new MqQueueSizeListener(connectionFactory);
    }

    private String getPassword() {
        try {
            return UserUtils.getPassord(accessKeySeret);
        } catch (InvalidKeyException | NoSuchAlgorithmException e) {
            logger.error("获取密码异常" + e.getMessage(), e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

}