package com.xforceplus.elephant.image.config;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.RecStatus;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericToStringSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Slf4j
@Configuration
public class CacheConfig {

    @Bean
    public LoadingCache<Long, Map<String, Integer>> userRecCountCache() {
        return CacheBuilder.newBuilder()
            .expireAfterWrite(5L, TimeUnit.MINUTES)
            .maximumSize(5000L)
            .build(new CacheLoader<Long, Map<String, Integer>>() {
                @Override
                public Map<String, Integer> load(final Long key) {
                    log.debug("初始缓存:{}", key);
                    final Map<String, Integer> count = new HashMap<>();
                    count.put("-1", 0);
                    count.put(RecStatus._0.getCode(), 0);
                    count.put(RecStatus._1.getCode(), 0);
                    count.put(RecStatus._2.getCode(), 0);
                    return count;
                }
            });
    }

    @Bean
    public LoadingCache<String, Map<String, Integer>> billRecCountCache() {
        return CacheBuilder.newBuilder()
            .expireAfterWrite(5L, TimeUnit.MINUTES)
            .maximumSize(5000L)
            .build(new CacheLoader<String, Map<String, Integer>>() {
                @Override
                public Map<String, Integer> load(final String key) {
                    log.debug("初始缓存:{}", key);
                    final Map<String, Integer> count = new HashMap<>();
                    count.put("-1", 0);
                    count.put(RecStatus._0.getCode(), 0);
                    count.put(RecStatus._1.getCode(), 0);
                    count.put(RecStatus._2.getCode(), 0);
                    return count;
                }
            });
    }

    @Bean("redisTemplate")
    public RedisTemplate<Object, Object> redisTemplate(final RedisConnectionFactory redisConnectionFactory) throws UnknownHostException {
        final RedisTemplate<Object, Object> template = new RedisTemplate();
        template.setConnectionFactory(redisConnectionFactory);
        template.setKeySerializer(new StringRedisSerializer());
        template.setHashKeySerializer(new StringRedisSerializer());
        return template;
    }

    @Bean("imageStringRedisTemplate")
    public RedisTemplate<Object, Object> imageStringRedisTemplate(final RedisConnectionFactory redisConnectionFactory) throws UnknownHostException {
        final RedisTemplate<Object, Object> template = new RedisTemplate();
        template.setConnectionFactory(redisConnectionFactory);
        template.setKeySerializer(new StringRedisSerializer());
        template.setValueSerializer(new GenericToStringSerializer(Object.class));
        return template;
    }
}
