package com.xforceplus.elephant.image.config;

import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.prometheus.client.Counter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

/**
 * @Description
 * @Date 2020/6/9 13:51
 * @Author wanghao
 * @Version 1.0
 */
public class PrometheusMetricsInterceptor extends HandlerInterceptorAdapter {

    private Counter requestCounter;

    public PrometheusMetricsInterceptor(PrometheusMeterRegistry prometheusMeterRegistry) {
        requestCounter = Counter.build()
            .name("image_web_http_requests_total").labelNames("path", "method", "code")
            .help("Total requests.").register(prometheusMeterRegistry.getPrometheusRegistry());
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        return super.preHandle(request, response, handler);
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        final String requestURI = request.getRequestURI();
        final String method = request.getMethod();
        final int status = response.getStatus();

        requestCounter.labels(requestURI, method, String.valueOf(status)).inc();
        super.afterCompletion(request, response, handler, ex);
    }

}
