package com.xforceplus.elephant.image.config;

import com.alibaba.csp.sentinel.annotation.aspectj.SentinelResourceAspect;
import com.alibaba.csp.sentinel.datasource.ReadableDataSource;
import com.alibaba.csp.sentinel.datasource.apollo.ApolloDataSource;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2022/3/21 15:04
 */
@Configuration
public class SentinelConfig {

    @Bean
    public SentinelResourceAspect sentinelResourceAspect() {
        return new SentinelResourceAspect();
    }

    @PostConstruct
    public void initFlowRules() {
        final String namespaceName = "application";
        final String flowRuleKey = "flowRules";

        final List<FlowRule> rules = ImmutableList.of(
            new FlowRule("userRecStatus").setCount(5),
            new FlowRule("billRecStatus").setCount(5),
            new FlowRule("countRecStatus").setCount(5)
        );

        final ReadableDataSource<String, List<FlowRule>> flowRuleDataSource = new ApolloDataSource<>(namespaceName,
            flowRuleKey, JSONObject.toJSONString(rules),
            source -> JSON.parseObject(source, new TypeReference<List<FlowRule>>() {
            }));
        FlowRuleManager.register2Property(flowRuleDataSource.getProperty());
    }

    @Bean
    public SentinelAlarm sentinelNotice() {
        return new SentinelAlarm();
    }

}
