package com.xforceplus.elephant.image.config;

import com.alibaba.csp.sentinel.adapter.spring.webmvc.SentinelWebInterceptor;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.SentinelWebTotalInterceptor;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.callback.BlockExceptionHandler;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.config.SentinelWebMvcConfig;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.config.SentinelWebMvcTotalConfig;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.xforceplus.elephant.basecommon.help.IpAddressUtils;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2022/5/31 15:13
 */
@Configuration
@Slf4j
public class SentinelInterceptor implements WebMvcConfigurer {

    @Autowired
    private SentinelAlarm sentinelAlarm;

    @Override
    public void addInterceptors(final InterceptorRegistry registry) {
        // Add Sentinel interceptor
        addSpringMvcInterceptor(registry);
    }

    private void addSpringMvcInterceptor(final InterceptorRegistry registry) {

        final SentinelWebMvcConfig config = new SentinelWebMvcConfig();
        // Depending on your situation, you can choose to process the BlockException via
        // the BlockExceptionHandler or throw it directly, then handle it
        // in Spring web global exception handler.

        // config.setBlockExceptionHandler((request, response, e) -> { throw e; });

        // Use the default handler.
        config.setBlockExceptionHandler(blockExceptionHandler());

        // Custom configuration if necessary
        config.setHttpMethodSpecify(false);
        // By default web context is true, means that unify web context(i.e. use the default context name),
        // in most scenarios that's enough, and it could reduce the memory footprint.
        // If set it to false, entrance contexts will be separated by different URLs,
        // which is useful to support "chain" relation flow strategy.
        // We can change it and view different result in `Resource Chain` menu of dashboard.
        config.setWebContextUnify(true);

        //config.setUrlCleaner()

        //Optional.ofNullable(UserInfoHolder.get()).ifPresent(user -> {
        //    config.setOriginParser(request -> String.valueOf(user.getId()));
        //});
        config.setOriginParser(request -> IpAddressUtils.getRealIpAdrress(request));

        // Add sentinel interceptor
        registry.addInterceptor(new SentinelWebInterceptor(config));
    }

    private void addSpringMvcTotalInterceptor(final InterceptorRegistry registry) {
        //Config
        final SentinelWebMvcTotalConfig config = new SentinelWebMvcTotalConfig();

        //Custom configuration if necessary
        config.setRequestAttributeName("my_sentinel_spring_mvc_total_entity_container");
        config.setTotalResourceName("my-spring-mvc-total-url-request");

        //Add sentinel interceptor
        registry.addInterceptor(new SentinelWebTotalInterceptor(config)).addPathPatterns("/**");
    }

    public BlockExceptionHandler blockExceptionHandler() {
        return (HttpServletRequest request, HttpServletResponse response, BlockException e) -> {
            response.setStatus(HttpStatus.TOO_MANY_REQUESTS.value());
            final PrintWriter out = response.getWriter();
            out.print("flow limiting");
            out.flush();
            out.close();

            log.warn(e.getRule().getResource(), e);
            sentinelAlarm.sendNotice(e);
        };
    }

}
