package com.xforceplus.elephant.image.config;

import com.xforceplus.apollo.client.netty.MCFactory;
import com.xforceplus.apollo.pool.thread.ApolloThread;
import com.xforceplus.apollo.pool.thread.ApolloThreadPool;
import com.xforceplus.tech.common.utils.JsonHelper;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@RequiredArgsConstructor
@Slf4j
public class TCPMessageConfig {

    @Value("${xforce.janus.userId:}")
    private String userId;
    @Value("${xforce.janus.host:}")
    private String host;
    @Value("${xforce.janus.port:}")
    private Integer port;

    @Bean
    public MCFactory mcFactory() {
        final ApolloThread apolloThread = new ApolloThread() {
            @Override
            public Object call() throws Exception {
                return null;
            }
        };
        apolloThread.setThreadName("heartBeatThread");
        ApolloThreadPool.getInstance().submit(apolloThread);
        final MCFactory mcFactory = MCFactory.getInstance(userId, host, port);
        mcFactory.registerListener(sealedMessage -> {
            log.info("接收消息sealedMessage:{}", JsonHelper.toJsonStr(sealedMessage));
            return false;
        });
        return mcFactory;
    }

}
