package com.xforceplus.elephant.image.config;

import com.xforceplus.tenant.security.client.feign.service.ClientService;
import com.xforceplus.ultraman.extensions.messagecenter.config.GatewayUrlSupplier;
import com.xforceplus.ultraman.extensions.messagecenter.config.MessageAppIdSupplier;
import com.xforceplus.ultraman.extensions.messagecenter.config.MessageTokenSupplier;
import com.xforceplus.ultraman.extensions.storage.config.StorageAppIdSupplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class UltramanExportConfig {

    @Value("${xforce.root:}")
    private String gatewayUrl;
    @Value("${xforce.tenant_security.appid:}")
    private String appId;
    @Autowired
    private ClientService clientService;

    @Bean
    public MessageAppIdSupplier messageAppIdSupplier() {
        return () -> appId;
    }

    @Bean
    public MessageTokenSupplier messageTokenSupplier() {
        return () -> clientService.token();
    }

    @Bean
    public GatewayUrlSupplier gatewayUrlSupplier() {
        return () -> gatewayUrl;
    }

    @Bean
    public StorageAppIdSupplier storageAppIdSupplier() {
        return () -> "elephant";
    }

}
