package com.xforceplus.elephant.image.controller;

import com.xforceplus.elephant.basecommon.dispatch.BeanDispatcher;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseController {

    protected Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    protected BeanDispatcher beanDispatcher;

    protected <T> T process(Class<T> tClass) {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        final Long tenantId = authorizedUser != null ? authorizedUser.getTenantId() : null;
        return beanDispatcher.dispatch(tenantId, tClass);
    }

}
